/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects.trigger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.core.PlayerScoreboardHandler;
import me.jasperjh.animatedscoreboard.enums.Messages;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import me.jasperjh.animatedscoreboard.objects.trigger.PlayerScoreboardTriggerTemplate;
import me.jasperjh.animatedscoreboard.objects.trigger.Trigger;
import me.jasperjh.animatedscoreboard.objects.trigger.reflection.TriggerMethod;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class PlayerTriggerHandler {
    private Map<String, Trigger> triggers = new HashMap<String, Trigger>();
    private RegisteredListener registeredListener;
    private PlayerScoreboardHandler scoreboardHandler;
    private AnimatedScoreboard plugin;
    private final boolean enabled;
    private final Set<HandlerList> excludedHandlers;

    public PlayerTriggerHandler(PlayerScoreboardHandler scoreboardHandler, AnimatedScoreboard plugin, boolean enabled) {
        this.scoreboardHandler = scoreboardHandler;
        this.plugin = plugin;
        this.enabled = enabled;
        this.excludedHandlers = new HashSet<HandlerList>();
        this.excludeHandler("com.destroystokyo.paper.event.player.PlayerHandshakeEvent");
    }

    public Map<String, Trigger> getTriggers() {
        return this.triggers;
    }

    private void excludeHandler(String className) {
        if (!this.enabled) {
            return;
        }
        try {
            Class<?> eventClass = Class.forName(className);
            Method method = eventClass.getMethod("getHandlerList", new Class[0]);
            Object handlerList = method.invoke(null, new Object[0]);
            if (handlerList instanceof HandlerList) {
                this.plugin.log(Level.INFO, "Excluding class {0} from triggers due to incompatibilities.", className);
                this.excludedHandlers.add((HandlerList)handlerList);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.plugin.log(Level.FINE, "Error {0} while excluding class {1} from triggers, this will not break anything!", e.getMessage(), className);
        }
    }

    public void insert() {
        if (!this.enabled) {
            return;
        }
        if (this.registeredListener == null) {
            Listener listener = new Listener(){};
            this.registeredListener = new RegisteredListener(listener, (l, event) -> this.checkTrigger(event), EventPriority.MONITOR, (Plugin)this.plugin, false);
        }
        for (HandlerList handler : HandlerList.getHandlerLists()) {
            if (this.excludedHandlers.contains(handler)) continue;
            handler.unregister(this.registeredListener);
            handler.register(this.registeredListener);
        }
    }

    public void addTrigger(String eventName, PlayerScoreboardTriggerTemplate boardToTrigger, String condition, long stayTime, String targetPlayer, boolean resetScoreboard) {
        if (!this.enabled) {
            return;
        }
        TriggerMethod playerMethod = null;
        try {
            Class<?> clas = Class.forName(eventName);
            if (!Event.class.isAssignableFrom(clas)) {
                throw new ClassNotFoundException("");
            }
            playerMethod = new TriggerMethod(this.plugin);
            playerMethod.load(clas, targetPlayer);
            if (playerMethod.getMethod() == null) {
                return;
            }
        }
        catch (ClassNotFoundException | SecurityException e) {
            Messages.TRIGGER_REGISTER_INVALID.log(this.plugin, Level.SEVERE, "%class_name%", eventName);
            return;
        }
        if (this.triggers.containsKey(eventName.toLowerCase())) {
            Messages.TRIGGER_REGISTER_SECOND.log(this.plugin, Level.SEVERE, "%class_name%", eventName);
            return;
        }
        Trigger trigger = new Trigger(eventName, boardToTrigger, condition, stayTime, playerMethod, resetScoreboard);
        this.triggers.put(eventName.toLowerCase(), trigger);
        this.scoreboardHandler.addTriggerScoreboard(trigger.getBoardToTrigger());
        this.plugin.log(Level.INFO, "Successfully registered {0} to trigger the {1} scoreboard that will stay for {2} ticks and target player returned by the {3} method!", eventName, boardToTrigger.getName(), stayTime, targetPlayer);
    }

    void checkTrigger(Event event) {
        if (!this.enabled) {
            return;
        }
        String className = event.getClass().getName().toLowerCase();
        if (!this.triggers.containsKey(className)) {
            return;
        }
        Trigger trigger = this.triggers.get(className);
        if (trigger.hasCondition()) {
            return;
        }
        TriggerMethod playerMethod = trigger.getPlayerMethod();
        Player player = (Player)playerMethod.get(event);
        ScoreboardPlayer scoreboardPlayer = this.scoreboardHandler.getPlayer(player);
        scoreboardPlayer.switchTemporaryScoreboard(trigger);
    }

    public PlayerTriggerHandler listen() {
        if (!this.enabled) {
            return this;
        }
        this.insert();
        return this;
    }

    public PlayerTriggerHandler unlisten() {
        if (!this.enabled) {
            return this;
        }
        for (HandlerList handler : HandlerList.getHandlerLists()) {
            handler.unregister(this.registeredListener);
        }
        this.registeredListener = null;
        return this;
    }

    public void clear() {
        this.triggers.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

