/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Optional;
import me.jasperjh.animatedscoreboard.enums.ScoreboardState;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboard;
import me.jasperjh.animatedscoreboard.objects.ScoreboardImplementation;
import me.jasperjh.animatedscoreboard.util.ScoreboardReflection;
import org.bukkit.entity.Player;

public class PacketImplementation
implements ScoreboardImplementation {
    private final ScoreboardReflection scoreboardReflection = new ScoreboardReflection();

    @Override
    public boolean hasMaxLength() {
        return false;
    }

    @Override
    public boolean hasScoreboard(Player player, String name) {
        return player != null && name != null;
    }

    @Override
    public boolean isInitialized(PlayerScoreboard playerScoreboard) {
        return playerScoreboard.getState() != ScoreboardState.UNINITIALIZED;
    }

    @Override
    public void initialize(PlayerScoreboard playerScoreboard, String title) {
        try {
            if (this.isValid(playerScoreboard)) {
                playerScoreboard.setState(ScoreboardState.INITIALIZING);
                Object packet = this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveConstructor().newInstance();
                this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveName().set(packet, playerScoreboard.getScoreboardPlayer().getObjectiveName());
                this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveDisplayName().set(packet, this.scoreboardReflection.fromString(title));
                this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveHealthDisplay().set(packet, this.scoreboardReflection.getIntegerHealthDisplay());
                this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveMode().set(packet, 0);
                this.scoreboardReflection.sendPacket(playerScoreboard.getScoreboardPlayer(), packet);
                packet = this.scoreboardReflection.getPacketPlayOutScoreboardDisplayObjectiveConstructor().newInstance();
                this.scoreboardReflection.getPacketPlayOutScoreboardDisplayObjectivePosition().set(packet, 1);
                this.scoreboardReflection.getPacketPlayOutScoreboardDisplayObjectiveName().set(packet, playerScoreboard.getScoreboardPlayer().getObjectiveName());
                this.scoreboardReflection.sendPacket(playerScoreboard.getScoreboardPlayer(), packet);
                playerScoreboard.setState(ScoreboardState.INITIALIZED);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isValid(PlayerScoreboard playerScoreboard) {
        return playerScoreboard != null && playerScoreboard.getScoreboardPlayer() != null && playerScoreboard.getScoreboardPlayer().getPlayer() != null;
    }

    @Override
    public void setTitle(Player player, String objectiveName, String title) {
        try {
            Object packet = this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveConstructor().newInstance();
            this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveName().set(packet, objectiveName);
            this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveDisplayName().set(packet, this.scoreboardReflection.fromString(title));
            this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveHealthDisplay().set(packet, this.scoreboardReflection.getIntegerHealthDisplay());
            this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveMode().set(packet, 2);
            this.scoreboardReflection.sendPacket(player, packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setLine(Player player, String teamName, String prefix, String suffix, boolean forceLegacy) {
        try {
            Object packet = this.scoreboardReflection.getPacketPlayOutScoreboardTeamConstructor().newInstance();
            this.scoreboardReflection.getPacketPlayOutScoreboardTeamName().set(packet, teamName);
            this.scoreboardReflection.getPacketPlayOutScoreboardTeamMode().set(packet, 2);
            if (this.scoreboardReflection.isVersionSpecificNMS()) {
                this.scoreboardReflection.getPacketPlayOutScoreboardTeamDisplayName().set(packet, this.scoreboardReflection.fromString(teamName));
                this.scoreboardReflection.getPacketPlayOutScoreboardTeamPrefix().set(packet, this.scoreboardReflection.fromString(prefix));
                this.scoreboardReflection.getPacketPlayOutScoreboardTeamSuffix().set(packet, this.scoreboardReflection.fromString(suffix));
                if (forceLegacy) {
                    this.scoreboardReflection.getPacketPlayOutScoreboardTeamColor().set(packet, this.scoreboardReflection.getChatColorWhite());
                }
            } else {
                Object teamData = this.scoreboardReflection.getScoreboardTeamDataConstructor().newInstance();
                this.scoreboardReflection.getScoreboardTeamDataDisplayName().set(teamData, this.scoreboardReflection.fromString(teamName));
                this.scoreboardReflection.getScoreboardTeamDataPrefix().set(teamData, this.scoreboardReflection.fromString(prefix));
                this.scoreboardReflection.getScoreboardTeamDataSuffix().set(teamData, this.scoreboardReflection.fromString(suffix));
                this.scoreboardReflection.getScoreboardTeamDataColor().set(teamData, this.scoreboardReflection.getChatColorWhite());
                this.scoreboardReflection.getScoreboardTeamDataNametagVisibility().set(teamData, "ALWAYS");
                this.scoreboardReflection.getScoreboardTeamDataCollisionRule().set(teamData, "ALWAYS");
                this.scoreboardReflection.getPacketPlayOutScoreboardTeamData().set(packet, Optional.of(teamData));
            }
            this.scoreboardReflection.sendPacket(player, packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void remove(PlayerScoreboard playerScoreboard) {
        try {
            Object packet = this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveConstructor().newInstance();
            this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveName().set(packet, playerScoreboard.getScoreboardPlayer().getObjectiveName());
            this.scoreboardReflection.getPacketPlayOutScoreboardObjectiveMode().set(packet, 1);
            if (this.isValid(playerScoreboard)) {
                this.scoreboardReflection.sendPacket(playerScoreboard.getScoreboardPlayer(), packet);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateScore(PlayerScoreboard playerScoreboard, String teamMember, int score) {
        try {
            Object packet = this.scoreboardReflection.getPacketPlayOutScoreboardScoreConstructor().newInstance();
            this.scoreboardReflection.getPacketPlayOutScoreboardScoreName().set(packet, teamMember);
            this.scoreboardReflection.getPacketPlayOutScoreboardScoreObjectiveName().set(packet, playerScoreboard.getScoreboardPlayer().getObjectiveName());
            this.scoreboardReflection.getPacketPlayOutScoreboardScoreValue().set(packet, score);
            this.scoreboardReflection.getPacketPlayOutScoreboardScoreAction().set(packet, this.scoreboardReflection.getScoreboardActionChange());
            if (this.isValid(playerScoreboard)) {
                this.scoreboardReflection.sendPacket(playerScoreboard.getScoreboardPlayer(), packet);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resetScores(Player player, String name) {
        try {
            Object packet = this.scoreboardReflection.getPacketPlayOutScoreboardScoreConstructor().newInstance();
            this.scoreboardReflection.getPacketPlayOutScoreboardScoreName().set(packet, name);
            this.scoreboardReflection.getPacketPlayOutScoreboardScoreAction().set(packet, this.scoreboardReflection.getScoreboardActionRemove());
            this.scoreboardReflection.sendPacket(player, packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerTeam(Player player, String name, String teamMember, boolean forceLegacy) {
        try {
            Object packet = this.scoreboardReflection.getPacketPlayOutScoreboardTeamConstructor().newInstance();
            this.scoreboardReflection.getPacketPlayOutScoreboardTeamName().set(packet, name);
            this.scoreboardReflection.getPacketPlayOutScoreboardTeamNames().set(packet, Collections.singletonList(teamMember));
            this.scoreboardReflection.getPacketPlayOutScoreboardTeamMode().set(packet, 0);
            if (this.scoreboardReflection.isVersionSpecificNMS()) {
                this.scoreboardReflection.getPacketPlayOutScoreboardTeamDisplayName().set(packet, this.scoreboardReflection.fromString(name));
                this.scoreboardReflection.getPacketPlayOutScoreboardTeamPrefix().set(packet, this.scoreboardReflection.fromString(""));
                this.scoreboardReflection.getPacketPlayOutScoreboardTeamSuffix().set(packet, this.scoreboardReflection.fromString(""));
                if (forceLegacy) {
                    this.scoreboardReflection.getPacketPlayOutScoreboardTeamColor().set(packet, this.scoreboardReflection.getChatColorWhite());
                }
            } else {
                Object teamData = this.scoreboardReflection.getScoreboardTeamDataConstructor().newInstance();
                this.scoreboardReflection.getScoreboardTeamDataDisplayName().set(teamData, this.scoreboardReflection.fromString(name));
                this.scoreboardReflection.getScoreboardTeamDataPrefix().set(teamData, this.scoreboardReflection.fromString(""));
                this.scoreboardReflection.getScoreboardTeamDataSuffix().set(teamData, this.scoreboardReflection.fromString(""));
                this.scoreboardReflection.getScoreboardTeamDataColor().set(teamData, this.scoreboardReflection.getChatColorWhite());
                this.scoreboardReflection.getScoreboardTeamDataNametagVisibility().set(teamData, "ALWAYS");
                this.scoreboardReflection.getScoreboardTeamDataCollisionRule().set(teamData, "ALWAYS");
                this.scoreboardReflection.getPacketPlayOutScoreboardTeamData().set(packet, Optional.of(teamData));
            }
            this.scoreboardReflection.sendPacket(player, packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unregisterTeam(Player player, String name) {
        try {
            Object packet = this.scoreboardReflection.getPacketPlayOutScoreboardTeamConstructor().newInstance();
            this.scoreboardReflection.getPacketPlayOutScoreboardTeamName().set(packet, name);
            this.scoreboardReflection.getPacketPlayOutScoreboardTeamMode().set(packet, 1);
            this.scoreboardReflection.sendPacket(player, packet);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

