/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects.impl;

import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.enums.ScoreboardState;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboard;
import me.jasperjh.animatedscoreboard.objects.ScoreboardImplementation;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class BukkitImplementation
implements ScoreboardImplementation {
    @Override
    public boolean hasMaxLength() {
        return true;
    }

    @Override
    public boolean hasScoreboard(Player player, String name) {
        return player.getScoreboard().getObjective(DisplaySlot.SIDEBAR) != null ? name != null && name.equalsIgnoreCase(player.getScoreboard().getObjective(DisplaySlot.SIDEBAR).getName()) : false;
    }

    @Override
    public boolean isInitialized(PlayerScoreboard playerScoreboard) {
        return playerScoreboard.getState() == ScoreboardState.INITIALIZED || playerScoreboard.getState() == ScoreboardState.INITIALIZING && !Bukkit.isPrimaryThread();
    }

    @Override
    public void initialize(PlayerScoreboard playerScoreboard, String title) {
        if (this.isInitialized(playerScoreboard)) {
            return;
        }
        String objectiveName = playerScoreboard.getScoreboardPlayer().getObjectiveName();
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)JavaPlugin.getPlugin(AnimatedScoreboard.class), () -> this.initialize(playerScoreboard, title));
            playerScoreboard.setState(ScoreboardState.INITIALIZING);
            return;
        }
        playerScoreboard.setState(ScoreboardState.INITIALIZING);
        Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective obj = board.getObjective(objectiveName);
        if (obj == null) {
            obj = board.registerNewObjective(objectiveName, "dummy");
        }
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        playerScoreboard.getScoreboardPlayer().getPlayer().setScoreboard(board);
        playerScoreboard.setState(ScoreboardState.INITIALIZED);
    }

    @Override
    public boolean isValid(PlayerScoreboard playerScoreboard) {
        if (playerScoreboard.getScoreboardPlayer() == null) {
            return false;
        }
        Scoreboard board = playerScoreboard.getScoreboardPlayer().getPlayer().getScoreboard();
        if (board == null || board.getObjective(DisplaySlot.SIDEBAR) == null || board.getObjective(playerScoreboard.getScoreboardPlayer().getObjectiveName()) == null) {
            if (playerScoreboard.getState() == ScoreboardState.INITIALIZED) {
                playerScoreboard.setState(ScoreboardState.UNINITIALIZED);
            }
            return false;
        }
        return true;
    }

    @Override
    public void setTitle(Player player, String objectiveName, String title) {
        player.getScoreboard().getObjective(objectiveName).setDisplayName(title);
    }

    @Override
    public void setLine(Player player, String teamName, String prefix, String suffix, boolean forceLegacy) {
        Scoreboard scoreboard = player.getScoreboard();
        if (scoreboard == null) {
            return;
        }
        Team team = scoreboard.getTeam(teamName);
        team.setPrefix(prefix);
        team.setSuffix(suffix);
    }

    @Override
    public void remove(PlayerScoreboard playerScoreboard) {
        Scoreboard scoreboard = playerScoreboard.getScoreboardPlayer().getPlayer().getScoreboard();
        if (scoreboard == null) {
            return;
        }
        Objective obj = scoreboard.getObjective(playerScoreboard.getScoreboardPlayer().getObjectiveName());
        for (Team team : scoreboard.getTeams()) {
            team.unregister();
        }
        for (String string : scoreboard.getEntries()) {
            scoreboard.resetScores(string);
        }
        if (obj != null) {
            obj.unregister();
        }
        if (playerScoreboard.getScoreboardPlayer().getPlayer() != null) {
            playerScoreboard.getScoreboardPlayer().getPlayer().setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        }
    }

    @Override
    public void updateScore(PlayerScoreboard playerScoreboard, String teamMember, int score) {
        Scoreboard scoreboard = playerScoreboard.getScoreboardPlayer().getPlayer().getScoreboard();
        if (scoreboard == null) {
            return;
        }
        scoreboard.getObjective(DisplaySlot.SIDEBAR).getScore(teamMember).setScore(score);
    }

    @Override
    public void resetScores(Player player, String name) {
        Scoreboard scoreboard = player.getScoreboard();
        if (scoreboard == null) {
            return;
        }
        scoreboard.resetScores(name);
    }

    @Override
    public void registerTeam(Player player, String name, String teamMember, boolean forceLegacy) {
        Scoreboard scoreboard = player.getScoreboard();
        if (scoreboard == null) {
            return;
        }
        Team team = scoreboard.getTeam(name);
        if (team == null) {
            team = scoreboard.registerNewTeam(name);
            team.addEntry(teamMember);
        }
        if (forceLegacy) {
            team.setColor(ChatColor.WHITE);
        }
    }

    @Override
    public void unregisterTeam(Player player, String name) {
        Scoreboard scoreboard = player.getScoreboard();
        if (scoreboard == null) {
            return;
        }
        Team team = scoreboard.getTeam(name);
        if (team != null) {
            team.unregister();
        }
    }
}

