/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects.format.syntax;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.jasperjh.animatedscoreboard.config.PlayerScoreboardFile;
import me.jasperjh.animatedscoreboard.objects.format.FileSyntax;
import me.jasperjh.animatedscoreboard.objects.format.FormattedLine;

public class ExpandedSyntax
implements FileSyntax {
    @Override
    public boolean isApplicable(PlayerScoreboardFile file) {
        return file.isConfigurationSection("display") && !file.isList("display.title") && !file.isList("display.board");
    }

    @Override
    public List<FormattedLine> parse(PlayerScoreboardFile file) {
        if (!file.contains("display")) {
            throw new RuntimeException("Display is null in '" + file.getFileName() + "'!");
        }
        Set keys = file.getConfigurationSection("display").getKeys(false);
        ArrayList<FormattedLine> lines = new ArrayList<FormattedLine>();
        int max = Math.min(15, keys.size() - 1);
        for (String display : keys) {
            List<String> text = file.getStringList("display." + display + ".text");
            int update = file.getInt("display." + display + ".interval", 0);
            boolean random = file.getBoolean("display." + display + ".random", false);
            String score = file.getString("display." + display + ".score", String.valueOf(max - lines.size()));
            lines.add(new FormattedLine(text, update, random, score));
        }
        return lines;
    }
}

