/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects.format.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.jasperjh.animatedscoreboard.config.PlayerScoreboardFile;
import me.jasperjh.animatedscoreboard.objects.format.FileSyntax;
import me.jasperjh.animatedscoreboard.objects.format.FormattedLine;

public class ExpandedListSyntax
implements FileSyntax {
    @Override
    public boolean isApplicable(PlayerScoreboardFile file) {
        return file.isConfigurationSection("display") && file.isList("display.title") && file.isList("display.board");
    }

    @Override
    public List<FormattedLine> parse(PlayerScoreboardFile file) {
        ArrayList<FormattedLine> lines = new ArrayList<FormattedLine>();
        lines.add(new FormattedLine(file.getStringList("display.title"), file.getInt("display.title-interval", 1), false, "0"));
        List<String> displayLines = file.getStringList("display.board");
        int max = Math.min(15, displayLines.size());
        for (String display : displayLines) {
            lines.add(new FormattedLine(Arrays.asList(display), 1, false, String.valueOf(max - lines.size())));
        }
        return lines;
    }
}

