/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects;

import java.util.ArrayList;
import java.util.List;
import me.jasperjh.animatedscoreboard.core.PlayerScoreboardHandler;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTemplate;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;

public class ScoreboardWorld {
    private final PlayerScoreboardHandler scoreboardHandler;
    private List<String> boards;

    public ScoreboardWorld(PlayerScoreboardHandler scoreboardHandler) {
        this.scoreboardHandler = scoreboardHandler;
        this.boards = new ArrayList<String>();
    }

    public void addBoard(PlayerScoreboardTemplate board) {
        this.boards.add(board.getName());
    }

    public void addBoard(String name) {
        this.boards.add(name);
    }

    public boolean hasScoreboard(PlayerScoreboardTemplate board) {
        return this.hasScoreboard(board.getName());
    }

    public boolean hasScoreboard(String board) {
        return this.boards.contains(board);
    }

    public PlayerScoreboardTemplate chooseBest(ScoreboardPlayer player) {
        if (!player.isScoreboardEnabled()) {
            return null;
        }
        for (String name : this.boards) {
            PlayerScoreboardTemplate board = this.scoreboardHandler.getScoreboardByName(name);
            if ((!board.hasPermission() || !player.getPlayer().hasPermission(board.getPermission())) && board.hasPermission()) continue;
            return board;
        }
        return null;
    }

    public void clearScoreboards() {
        this.boards.clear();
    }

    public PlayerScoreboardHandler getScoreboardHandler() {
        return this.scoreboardHandler;
    }

    public List<String> getBoards() {
        return this.boards;
    }
}

