/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.core.PlayerScoreboardHandler;
import me.jasperjh.animatedscoreboard.enums.ScoreboardState;
import me.jasperjh.animatedscoreboard.enums.WorldOption;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboard;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTemplate;
import me.jasperjh.animatedscoreboard.objects.ScoreboardImplementation;
import me.jasperjh.animatedscoreboard.objects.ScoreboardOption;
import me.jasperjh.animatedscoreboard.objects.ScoreboardWorld;
import me.jasperjh.animatedscoreboard.objects.trigger.PlayerScoreboardTriggerTemplate;
import me.jasperjh.animatedscoreboard.objects.trigger.PlayerTriggerScoreboard;
import me.jasperjh.animatedscoreboard.objects.trigger.Trigger;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;

public class ScoreboardPlayer {
    private final PlayerScoreboardHandler scoreboardHandler;
    private final ScoreboardImplementation implementation;
    private final Player player;
    private final String objectiveName;
    private PlayerScoreboard scoreboard;
    private long ticksLeft;
    private boolean awaitingRemoval;
    private boolean scoreboardEnabled;
    private PlayerScoreboardTemplate nextScoreboard;
    private final AtomicBoolean initializing;
    private boolean paused;

    public ScoreboardPlayer(AnimatedScoreboard plugin, Player player) {
        this.scoreboardHandler = plugin.getScoreboardHandler();
        this.implementation = plugin.getScoreboardImplementation();
        this.player = player;
        String tempScoreboardName = player.getPlayer().getName() + "-SB";
        if (tempScoreboardName.length() >= 16) {
            tempScoreboardName = tempScoreboardName.substring(15);
        }
        this.objectiveName = tempScoreboardName;
        ((CompletableFuture)plugin.getPlayerStorage().isScoreboardEnabled(player.getUniqueId()).exceptionally(exception -> {
            plugin.getLogger().log(Level.SEVERE, "Something went wrong when trying to load the scoreboard enabled status", (Throwable)exception);
            return true;
        })).thenAccept(enabled -> {
            this.scoreboardEnabled = enabled;
        });
        this.initializing = new AtomicBoolean(false);
    }

    public void setScoreboardEnabled(boolean enabled) {
        this.scoreboardEnabled = enabled;
    }

    public void enableScoreboard() {
        this.switchScoreboard(this.player.getWorld());
        this.scoreboardEnabled = true;
    }

    public void disableScoreboard() {
        this.removeScoreboard();
        this.scoreboardEnabled = false;
    }

    public boolean toggle() {
        boolean bl = this.scoreboardEnabled = !this.isScoreboardEnabled();
        if (this.scoreboardEnabled) {
            this.switchScoreboard(this.player.getWorld());
        } else {
            this.removeScoreboard();
        }
        return this.scoreboardEnabled;
    }

    public boolean hasScoreboard() {
        if (this.scoreboard != null) {
            return this.implementation.hasScoreboard(this.player, this.objectiveName);
        }
        return false;
    }

    public boolean hasTemporaryScoreboard() {
        if (this.hasScoreboard()) {
            return this.scoreboard instanceof PlayerTriggerScoreboard;
        }
        return false;
    }

    public PlayerScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public void tickTemporaryScoreboard() {
        if (this.ticksLeft <= 0L) {
            return;
        }
        --this.ticksLeft;
    }

    public void switchScoreboard(World world) {
        ScoreboardWorld scoreboardWorld = this.scoreboardHandler.getScoreboardWorldByName(world.getName());
        if (scoreboardWorld == null) {
            this.switchScoreboard(WorldOption.GLOBAL);
        } else {
            this.switchScoreboard(scoreboardWorld);
        }
    }

    public void recalculateScoreboard(World world) {
        ScoreboardWorld scoreboardWorld = this.scoreboardHandler.getScoreboardWorldByName(world.getName());
        if (scoreboardWorld == null) {
            this.recalculateScoreboard(WorldOption.GLOBAL);
        } else {
            this.recalculateScoreboard(scoreboardWorld);
        }
    }

    public void switchScoreboard(World world, PlayerScoreboardTemplate template) {
        ScoreboardWorld scoreboardWorld = this.scoreboardHandler.getScoreboardWorldByName(world.getName());
        if (scoreboardWorld == null || template == null) {
            this.switchScoreboard(WorldOption.GLOBAL, template);
        } else {
            this.switchScoreboard(template);
        }
    }

    public void recalculateScoreboard(World world, PlayerScoreboardTemplate template) {
        ScoreboardWorld scoreboardWorld = this.scoreboardHandler.getScoreboardWorldByName(world.getName());
        if (scoreboardWorld == null || template == null) {
            this.recalculateScoreboard(WorldOption.GLOBAL);
        } else {
            this.recalculateScoreboard(template);
        }
    }

    public void switchScoreboard(WorldOption option) {
        ScoreboardOption scoreboardOption = this.scoreboardHandler.getOption(option);
        if (scoreboardOption == null) {
            this.removeScoreboard();
            return;
        }
        PlayerScoreboardTemplate template = scoreboardOption.chooseBest(this);
        if (template == null) {
            this.removeScoreboard();
            return;
        }
        this.nextScoreboard = template;
    }

    public void recalculateScoreboard(WorldOption option) {
        ScoreboardOption scoreboardOption = this.scoreboardHandler.getOption(option);
        if (scoreboardOption == null) {
            return;
        }
        PlayerScoreboardTemplate template = scoreboardOption.chooseBest(this);
        if (template == null) {
            return;
        }
        if (this.scoreboard != null && this.scoreboard.getName().equalsIgnoreCase(template.getName())) {
            return;
        }
        this.nextScoreboard = template;
    }

    public void switchScoreboard(WorldOption option, PlayerScoreboardTemplate template) {
        ScoreboardOption scoreboardOption = this.scoreboardHandler.getOption(option);
        if (scoreboardOption == null) {
            this.removeScoreboard();
            return;
        }
        if (!scoreboardOption.hasScoreboard(template)) {
            this.removeScoreboard();
            return;
        }
        this.nextScoreboard = template;
    }

    public void recalculateScoreboard(WorldOption option, PlayerScoreboardTemplate template) {
        ScoreboardOption scoreboardOption = this.scoreboardHandler.getOption(option);
        if (scoreboardOption == null) {
            return;
        }
        if (!scoreboardOption.hasScoreboard(template)) {
            return;
        }
        if (this.scoreboard != null && this.scoreboard.getName().equalsIgnoreCase(template.getName())) {
            return;
        }
        this.nextScoreboard = template;
    }

    public void switchScoreboard(ScoreboardWorld world) {
        PlayerScoreboardTemplate template = world.chooseBest(this);
        if (template != null) {
            this.nextScoreboard = template;
        } else {
            this.switchScoreboard(WorldOption.GLOBAL);
        }
    }

    public void recalculateScoreboard(ScoreboardWorld world) {
        PlayerScoreboardTemplate template = world.chooseBest(this);
        if (template != null) {
            if (this.scoreboard != null && this.scoreboard.getName().equalsIgnoreCase(template.getName())) {
                return;
            }
            this.nextScoreboard = template;
        } else {
            this.recalculateScoreboard(WorldOption.GLOBAL);
        }
    }

    public void switchScoreboard(PlayerScoreboardTemplate template) {
        if (template == null) {
            this.removeScoreboard();
        }
        this.nextScoreboard = template;
    }

    public void recalculateScoreboard(PlayerScoreboardTemplate template) {
        if (this.scoreboard != null && this.scoreboard.getName().equalsIgnoreCase(template.getName())) {
            return;
        }
        this.nextScoreboard = template;
    }

    public void switchTemporaryScoreboard(PlayerScoreboardTriggerTemplate template, long stayTime) {
        this.ticksLeft = stayTime > 0L ? stayTime : Long.MIN_VALUE;
        if (this.hasTemporaryScoreboard() && this.scoreboard.getName().equalsIgnoreCase(template.getName())) {
            return;
        }
        this.nextScoreboard = template;
    }

    public void switchTemporaryScoreboard(Trigger trigger) {
        long stayTime = trigger.getStayTime();
        this.ticksLeft = stayTime > 0L ? stayTime : Long.MIN_VALUE;
        PlayerScoreboardTriggerTemplate template = trigger.getBoardToTrigger();
        if (this.hasTemporaryScoreboard() && !trigger.resetScoreboard() && this.scoreboard.getName().equalsIgnoreCase(template.getName())) {
            return;
        }
        this.nextScoreboard = template;
    }

    public boolean tickScoreboards() {
        if (!this.player.isOnline()) {
            return false;
        }
        if (this.awaitingRemoval) {
            this.removeScoreboardNow();
            this.awaitingRemoval = false;
        }
        if (!this.isScoreboardEnabled() || this.initializing.get()) {
            return true;
        }
        if (this.shouldPause()) {
            if (!this.paused) {
                this.removeScoreboardNow();
                this.paused = true;
            }
            return true;
        }
        if (this.paused) {
            this.switchScoreboard(this.player.getWorld());
            this.paused = false;
        }
        PlayerScoreboardTemplate template = this.nextScoreboard;
        this.nextScoreboard = null;
        if (template != null) {
            try {
                this.initializing.set(true);
                this.removeScoreboardNow();
                this.scoreboard = template.newScoreboard(this);
                this.scoreboard.initialize();
                boolean bl = true;
                return bl;
            }
            finally {
                this.initializing.set(false);
            }
        }
        if (this.hasScoreboard()) {
            if (this.hasTemporaryScoreboard()) {
                this.tickTemporaryScoreboard();
                if (this.ticksLeft == 0L) {
                    this.switchScoreboard(this.player.getWorld());
                    return true;
                }
            }
            this.scoreboard.update();
        } else if (this.scoreboard != null) {
            if (this.scoreboard.getState() == ScoreboardState.UNINITIALIZED) {
                this.switchScoreboard(this.player.getWorld());
            }
        } else if (!this.implementation.hasScoreboard(this.player, this.scoreboard == null ? null : this.objectiveName)) {
            this.switchScoreboard(this.player.getWorld());
        }
        return true;
    }

    private boolean shouldPause() {
        Player player = this.getPlayer();
        Objective objective = player.getScoreboard().getObjective(DisplaySlot.SIDEBAR);
        if (objective == null) {
            return false;
        }
        return !objective.getName().equalsIgnoreCase(this.objectiveName);
    }

    public void removeScoreboard() {
        if (!this.hasScoreboard()) {
            return;
        }
        this.awaitingRemoval = true;
    }

    public void removeScoreboardNow() {
        if (!this.hasScoreboard()) {
            return;
        }
        this.scoreboard.remove();
        this.scoreboard = null;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public boolean isAwaitingRemoval() {
        return this.awaitingRemoval;
    }

    public boolean isScoreboardEnabled() {
        return this.scoreboardEnabled;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

