/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects;

import java.util.List;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.config.PluginConfig;
import me.jasperjh.animatedscoreboard.enums.WorldOption;

public class PlayerScoreboardTemplateBuilder {
    private String key;
    private AnimatedScoreboard plugin;

    public void build() {
        PluginConfig configFile = this.plugin.getConfigFile();
        for (WorldOption option : WorldOption.values()) {
            if (!option.getKeyWord().equalsIgnoreCase(this.key)) continue;
            if (configFile.get("worlds." + this.key) instanceof String && !configFile.isList("worlds." + this.key)) {
                this.build(option, configFile.getString("worlds." + this.key).replaceAll(".yml", ""));
            } else if (configFile.isList("worlds." + this.key)) {
                this.build(option, configFile.getStringList("worlds." + this.key));
            }
            return;
        }
        if (configFile.get("worlds." + this.key) instanceof String && !configFile.isList("worlds." + this.key)) {
            this.build(this.key, configFile.getString("worlds." + this.key).replaceAll(".yml", ""));
        } else if (configFile.isList("worlds." + this.key)) {
            this.build(this.key, configFile.getStringList("worlds." + this.key));
        }
    }

    private void build(WorldOption option, String file) {
        this.plugin.getScoreboardHandler().addTemplate(option, file);
    }

    private void build(WorldOption option, List<String> files) {
        for (String file : files) {
            this.build(option, file);
        }
    }

    private void build(String key, String file) {
        this.plugin.getScoreboardHandler().addTemplate(key, file);
    }

    private void build(String key, List<String> files) {
        for (String file : files) {
            this.build(key, file);
        }
    }

    public PlayerScoreboardTemplateBuilder(String key, AnimatedScoreboard plugin) {
        this.key = key;
        this.plugin = plugin;
    }
}

