/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects;

import java.util.List;
import java.util.stream.Collectors;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.config.PlayerScoreboardFile;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboard;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardLineTemplate;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;

public class PlayerScoreboardTemplate {
    private String permission;
    private List<PlayerScoreboardLineTemplate> template;
    private String name;
    protected AnimatedScoreboard plugin;

    public PlayerScoreboardTemplate(PlayerScoreboardFile config, String permission) {
        this.template = config.loadLines();
        this.permission = permission;
        this.name = config.getFileNameWithoutExtension();
        this.plugin = config.getPlugin();
    }

    public PlayerScoreboard newScoreboard(ScoreboardPlayer player) {
        return new PlayerScoreboard(this.plugin, this.name, player, this.template.stream().map(line -> line.newLine(player.getPlayer())).collect(Collectors.toList()));
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public String getPermission() {
        return this.permission;
    }

    public List<PlayerScoreboardLineTemplate> getTemplate() {
        return this.template;
    }

    public String getName() {
        return this.name;
    }

    public AnimatedScoreboard getPlugin() {
        return this.plugin;
    }
}

