/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects;

import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.core.PlaceholderHandler;
import me.jasperjh.animatedscoreboard.display.attribute.ConfigAttribute;
import me.jasperjh.animatedscoreboard.enums.ConfigSetting;
import me.jasperjh.animatedscoreboard.enums.LineType;
import me.jasperjh.animatedscoreboard.exceptions.PlaceholderParseException;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardDisplayLine;
import me.jasperjh.animatedscoreboard.util.Strings;
import org.bukkit.entity.Player;

public class PlayerScoreboardLine {
    private static final Random RANDOM_INSTANCE = new Random();
    private final Player player;
    private final int update;
    private final ConfigAttribute score;
    private final boolean random;
    private int currentScore;
    private int currentLine;
    private int currentUpdate;
    private List<PlayerScoreboardDisplayLine> displayLines;
    private boolean goNext = false;
    private int teamColorName;
    private String lastText;
    private boolean changed;

    public PlayerScoreboardLine(Player player, int update, ConfigAttribute score, boolean random, List<PlayerScoreboardDisplayLine> lines) {
        this.player = player;
        this.update = update;
        this.score = score;
        this.random = random;
        this.displayLines = lines;
        this.teamColorName = -1;
        this.currentScore = Integer.MIN_VALUE;
        this.changed = true;
    }

    public boolean shouldUpdate() {
        if (this.displayLines.size() <= this.currentLine) {
            return false;
        }
        PlayerScoreboardDisplayLine line = this.displayLines.get(this.currentLine);
        LineType type = line.getType();
        if (type.shouldOverrideUpdate() && !type.shouldOverrideStay()) {
            if (this.currentUpdate++ == this.update) {
                this.currentUpdate = 0;
                this.goNext = true;
                return true;
            }
        } else if (!type.shouldOverrideUpdate()) {
            if (this.currentUpdate++ == this.update) {
                this.currentUpdate = 0;
                return true;
            }
            return false;
        }
        return line.shouldUpdate();
    }

    public boolean updateStay() {
        if (this.displayLines.size() <= this.currentLine) {
            return false;
        }
        PlayerScoreboardDisplayLine line = this.displayLines.get(this.currentLine);
        boolean shouldStay = line.shouldStay();
        if (line.getType().shouldOverrideUpdate() && !line.getType().shouldOverrideStay()) {
            return shouldStay;
        }
        if (!this.goNext && !shouldStay) {
            this.goNext = true;
        }
        return shouldStay;
    }

    public String update(boolean force, PlaceholderHandler placeholderHandler) {
        if (this.displayLines.size() <= this.currentLine) {
            return "";
        }
        String text = "";
        PlayerScoreboardDisplayLine line = this.displayLines.get(this.currentLine);
        if (force) {
            this.changed = true;
            text = line.update();
        } else if (this.goNext) {
            this.goNext = false;
            text = this.next();
            line = this.displayLines.get(this.currentLine);
        } else {
            text = line.update();
        }
        if (line.shouldReplacePlaceholders() && this.player != null) {
            block12: {
                try {
                    text = placeholderHandler.replacePlaceholdersThrows(this.player, text);
                }
                catch (PlaceholderParseException e) {
                    boolean disabled = line.updateLastError();
                    if (e.getCause() == null || e.getMessage() == null) {
                        e.printStackTrace();
                    } else {
                        AnimatedScoreboard.getInstance().log(Level.SEVERE, e.getMessage(), new Object[0]);
                        e.getCause().printStackTrace();
                    }
                    if (!disabled) break block12;
                    AnimatedScoreboard.getInstance().log(Level.SEVERE, "Because the placeholder(s) in this line have exceeded the maximum number of exceptions AnimatedScoreboard will not attempt to load the placeholders anymore!", new Object[0]);
                }
            }
            if (ConfigSetting.HEX_IN_PLACEHOLDERS.getValue()) {
                text = Strings.parseColors(text);
            }
        }
        if (this.lastText == null || !this.lastText.equals(text)) {
            this.changed = true;
        }
        this.lastText = text;
        return text;
    }

    public boolean hasTextChanged() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    public String next() {
        if (this.random) {
            this.currentLine = RANDOM_INSTANCE.nextInt(this.displayLines.size());
        } else {
            ++this.currentLine;
            if (this.currentLine >= this.displayLines.size()) {
                this.currentLine = 0;
            }
        }
        this.currentUpdate = 0;
        return this.displayLines.get(this.currentLine).update();
    }

    public boolean hasScoreChanged() {
        int score;
        Object scoreObject = null;
        scoreObject = this.score.containsPlaceholder() ? this.score.getType().parse(this.player, this.score.getValue(this.player)) : this.score.getType().parse(this.player, this.score.getValue());
        if (scoreObject instanceof Integer && this.currentScore != (score = ((Integer)scoreObject).intValue())) {
            this.currentScore = score;
            return true;
        }
        score = ((Double)scoreObject).intValue();
        if (this.currentScore != score) {
            this.currentScore = score;
            return true;
        }
        return false;
    }

    protected ConfigAttribute getScoreAttribute() {
        return this.score;
    }

    public void removeAll() {
        this.displayLines.removeIf(line -> {
            line.removeAll();
            return true;
        });
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getUpdate() {
        return this.update;
    }

    public ConfigAttribute getScore() {
        return this.score;
    }

    public boolean isRandom() {
        return this.random;
    }

    public int getCurrentScore() {
        return this.currentScore;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentUpdate() {
        return this.currentUpdate;
    }

    public List<PlayerScoreboardDisplayLine> getDisplayLines() {
        return this.displayLines;
    }

    public boolean isGoNext() {
        return this.goNext;
    }

    public int getTeamColorName() {
        return this.teamColorName;
    }

    public String getLastText() {
        return this.lastText;
    }

    public void setTeamColorName(int teamColorName) {
        this.teamColorName = teamColorName;
    }
}

