/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects;

import me.jasperjh.animatedscoreboard.enums.LineType;
import org.bukkit.entity.Player;

public abstract class PlayerScoreboardDisplayLine {
    private static final long BASE_COOLDOWN = 30000L;
    private static final long MAX_ATTEMPTS = 2L;
    private final boolean placeholders;
    private final LineType lineType;
    private long lastError;
    private long attempts = 1L;

    public boolean updateLastError() {
        if (this.attempts > 2L) {
            return false;
        }
        this.lastError = System.currentTimeMillis() + 30000L * this.attempts++;
        return this.attempts > 2L;
    }

    public boolean shouldReplacePlaceholders() {
        if (!this.hasPlaceholders() || this.attempts > 2L) {
            return false;
        }
        if (this.lastError == 0L) {
            return true;
        }
        return System.currentTimeMillis() - this.lastError >= 0L;
    }

    public boolean hasPlaceholders() {
        return this.placeholders;
    }

    public LineType getType() {
        return this.lineType;
    }

    public abstract Player getPlayer();

    public abstract boolean shouldStay();

    public abstract boolean shouldUpdate();

    public abstract String update();

    public abstract void removeAll();

    public PlayerScoreboardDisplayLine(boolean placeholders, LineType lineType) {
        this.placeholders = placeholders;
        this.lineType = lineType;
    }
}

