/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.core.PlaceholderHandler;
import me.jasperjh.animatedscoreboard.display.attribute.ConfigAttribute;
import me.jasperjh.animatedscoreboard.display.attribute.TagAttributes;
import me.jasperjh.animatedscoreboard.enums.AttributeType;
import me.jasperjh.animatedscoreboard.enums.ConfigSetting;
import me.jasperjh.animatedscoreboard.enums.Line;
import me.jasperjh.animatedscoreboard.enums.LineType;
import me.jasperjh.animatedscoreboard.enums.PatternType;
import me.jasperjh.animatedscoreboard.enums.ScoreboardState;
import me.jasperjh.animatedscoreboard.enums.ServerVersion;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardDisplayLine;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardLine;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTag;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTemporaryLine;
import me.jasperjh.animatedscoreboard.objects.ScoreboardImplementation;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import me.jasperjh.animatedscoreboard.util.Strings;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class PlayerScoreboard {
    private static final int ARTIFICIAL_MAX = 15000;
    private static final String MEMBER_PREFIX = ChatColor.translateAlternateColorCodes((char)'&', (String)"&A&5&B");
    private final AnimatedScoreboard plugin;
    private final ScoreboardImplementation implementation;
    private final String name;
    private PlaceholderHandler placeholderHandler;
    private ScoreboardPlayer scoreboardPlayer;
    private List<PlayerScoreboardLine> lines;
    private ScoreboardState state;
    private boolean legacyServer;
    private boolean forceLegacy;

    public PlayerScoreboard(AnimatedScoreboard plugin, String name, ScoreboardPlayer player, List<PlayerScoreboardLine> lines) {
        this.plugin = plugin;
        this.implementation = plugin.getScoreboardImplementation();
        this.name = name;
        this.placeholderHandler = plugin.getPlaceholderHandler();
        this.scoreboardPlayer = player;
        this.lines = lines;
        this.state = ScoreboardState.UNINITIALIZED;
        this.legacyServer = this.implementation.hasMaxLength() || ServerVersion.current().isLegacy();
        this.forceLegacy = !this.legacyServer && ConfigSetting.FORCE_LEGACY.getValue();
    }

    public PlayerScoreboardLine getLine(int index) {
        return this.lines.get(index);
    }

    public void update() {
        if (this.scoreboardPlayer == null) {
            return;
        }
        boolean clearTemp = false;
        if (this.lines == null) {
            return;
        }
        for (int current = 0; current < this.lines.size(); ++current) {
            PlayerScoreboardLine line2 = this.lines.get(current);
            if (line2.shouldUpdate()) {
                String text = line2.update(false, this.placeholderHandler);
                if (current > 0) {
                    if (line2.getTeamColorName() == -1) {
                        line2.setTeamColorName(this.findFreeColor());
                    }
                    int color = line2.getTeamColorName();
                    if (line2.hasTextChanged()) {
                        this.setLine(text, color);
                    }
                    if (line2.hasScoreChanged()) {
                        this.implementation.updateScore(this, this.toMemberName(color), line2.getCurrentScore());
                    }
                } else if (line2.hasTextChanged()) {
                    this.setTitle(text);
                }
            }
            if (line2 instanceof PlayerScoreboardTemporaryLine) {
                PlayerScoreboardTemporaryLine tempLine = (PlayerScoreboardTemporaryLine)line2;
                tempLine.setStayTime(tempLine.getStayTime() - 1L);
                if (tempLine.getStayTime() <= 0L) {
                    clearTemp = true;
                }
            }
            line2.updateStay();
        }
        if (clearTemp) {
            Stream<PlayerScoreboardTemporaryLine> stream = this.lines.stream().filter(line -> line instanceof PlayerScoreboardTemporaryLine && ((PlayerScoreboardTemporaryLine)line).getStayTime() <= 0L).map(PlayerScoreboardTemporaryLine.class::cast);
            stream.forEach(line -> {
                if (line.getOldLine() == null) {
                    Player player = this.scoreboardPlayer.getPlayer();
                    this.implementation.resetScores(player, this.toMemberName(line.getTeamColorName()));
                    this.implementation.unregisterTeam(player, "ASB-" + line.getTeamColorName());
                    return;
                }
                Collections.replaceAll(this.lines, line, line.getOldLine());
            });
            this.lines.removeIf(line -> line instanceof PlayerScoreboardTemporaryLine && ((PlayerScoreboardTemporaryLine)line).getStayTime() <= 0L);
            this.forceUpdate();
        }
    }

    public void forceUpdate() {
        if (this.scoreboardPlayer == null) {
            return;
        }
        int size = this.lines.size();
        for (int current = 0; current < size; ++current) {
            PlayerScoreboardLine line = this.lines.get(current);
            String text = line.update(true, this.placeholderHandler);
            if (current > 0) {
                if (line.getTeamColorName() == -1) {
                    line.setTeamColorName(this.findFreeColor());
                }
                int color = line.getTeamColorName();
                this.setLine(text, color);
                if (!line.hasScoreChanged()) continue;
                this.implementation.updateScore(this, this.toMemberName(color), line.getCurrentScore());
                continue;
            }
            this.setTitle(text);
        }
    }

    protected void initialize() {
        if (this.scoreboardPlayer == null || this.implementation.isInitialized(this)) {
            return;
        }
        String title = this.lines.size() > 0 ? this.lines.get(0).update(true, this.placeholderHandler) : null;
        this.implementation.initialize(this, title == null ? "" : title);
    }

    public void setState(ScoreboardState state) {
        this.state = state;
        if (state == ScoreboardState.INITIALIZED) {
            this.registerTeams();
        }
    }

    public void registerTeams() {
        for (int current = 1; current < this.lines.size(); ++current) {
            PlayerScoreboardLine line = this.lines.get(current);
            if (line.getTeamColorName() == -1) {
                line.setTeamColorName(this.findFreeColor());
            }
            int color = line.getTeamColorName();
            String name = "ASB-" + color;
            this.implementation.registerTeam(this.scoreboardPlayer.getPlayer(), name, this.toMemberName(color), this.forceLegacy);
        }
        this.forceUpdate();
    }

    private void setTitle(String text) {
        if (!this.implementation.isValid(this)) {
            this.initialize();
            return;
        }
        if (text == null) {
            text = " ";
        }
        Player player = this.scoreboardPlayer.getPlayer();
        int maxLength = ServerVersion.current().getTitleLength();
        if (!this.hasMaxLength()) {
            maxLength = 15000;
        }
        if (text.length() >= maxLength) {
            text = text.substring(0, maxLength);
        }
        this.implementation.setTitle(player, this.scoreboardPlayer.getObjectiveName(), text);
    }

    private void setLine(String text, int line) {
        if (!this.implementation.isValid(this)) {
            this.initialize();
            return;
        }
        if (text == null) {
            text = Strings.spaces(line);
        }
        Player player = this.scoreboardPlayer.getPlayer();
        if (line >= ChatColor.values().length) {
            return;
        }
        String[] display = this.splitString(text);
        String teamName = "ASB-" + line;
        this.implementation.setLine(player, teamName, display[0], display[1], this.forceLegacy);
    }

    protected void remove() {
        if (this.scoreboardPlayer == null) {
            return;
        }
        for (int current = 1; current < this.lines.size(); ++current) {
            PlayerScoreboardLine line2 = this.lines.get(current);
            if (line2.getTeamColorName() == -1) {
                line2.setTeamColorName(this.findFreeColor());
            }
            int color = line2.getTeamColorName();
            String name = "ASB-" + color;
            this.implementation.unregisterTeam(this.scoreboardPlayer.getPlayer(), name);
            this.implementation.resetScores(this.scoreboardPlayer.getPlayer(), this.toMemberName(color));
        }
        this.implementation.remove(this);
        this.lines.removeIf(line -> {
            line.removeAll();
            return true;
        });
        this.lines = Collections.emptyList();
        this.scoreboardPlayer = null;
        this.state = ScoreboardState.UNINITIALIZED;
    }

    public void replace(int score, String text, int update, long time) {
        Optional<PlayerScoreboardLine> oldLine = this.lines.subList(1, this.lines.size()).stream().filter(line -> line.getCurrentScore() == score).findFirst();
        Matcher matcher = PatternType.TAG.getMatcher(text);
        PlayerScoreboardTag tag = null;
        if (matcher.find()) {
            String name = matcher.group(1);
            for (LineType type : EnumSet.range(LineType.values()[1], LineType.values()[LineType.values().length - 1])) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                TagAttributes attributes = type.newAttributes();
                Matcher m = PatternType.ATTRIBUTE.getMatcher(matcher.group(2).trim());
                while (m.find()) {
                    String[] attribute = m.group(0).trim().split("=");
                    attributes.applyValue(attributes.getAttribute(attribute[0]), attribute[1]);
                }
                tag = type.newTag(this.plugin, attributes, matcher.group(3));
                break;
            }
        }
        if (tag == null) {
            tag = LineType.DEFAULT.newTag(this.plugin, null, text);
        }
        PlayerScoreboardLine currentLine = oldLine.isPresent() ? oldLine.get() : null;
        PlayerScoreboardTemporaryLine newLine = null;
        newLine = currentLine != null ? new PlayerScoreboardTemporaryLine(this.scoreboardPlayer.getPlayer(), update, currentLine.getScoreAttribute(), currentLine.isRandom(), this.asList(tag.getLine(this.scoreboardPlayer.getPlayer())), time, currentLine) : new PlayerScoreboardTemporaryLine(this.scoreboardPlayer.getPlayer(), update, new ConfigAttribute(this.scoreboardPlayer.getObjectiveName(), AttributeType.INTEGER, "" + score), false, this.asList(tag.getLine(this.scoreboardPlayer.getPlayer())), time, null);
        this.replace(currentLine, newLine);
    }

    private List<PlayerScoreboardDisplayLine> asList(PlayerScoreboardDisplayLine line) {
        ArrayList<PlayerScoreboardDisplayLine> lines = new ArrayList<PlayerScoreboardDisplayLine>(1);
        lines.add(line);
        return lines;
    }

    public void replace(Line line, String text, int update, long time) {
        Matcher matcher = PatternType.TAG.getMatcher(text);
        PlayerScoreboardTag tag = null;
        if (matcher.find()) {
            String name = matcher.group(1);
            for (LineType type : EnumSet.range(LineType.values()[1], LineType.values()[LineType.values().length - 1])) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                TagAttributes attributes = type.newAttributes();
                Matcher m = PatternType.ATTRIBUTE.getMatcher(matcher.group(2).trim());
                while (m.find()) {
                    String[] attribute = m.group(0).trim().split("=");
                    attributes.applyValue(attributes.getAttribute(attribute[0]), attribute[1]);
                }
                tag = type.newTag(this.plugin, attributes, matcher.group(3));
                break;
            }
        }
        if (tag == null) {
            tag = LineType.DEFAULT.newTag(this.plugin, null, text);
        }
        this.replace(line, tag, update, time);
    }

    public void replace(Line line, PlayerScoreboardTag tag, int update, long time) {
        PlayerScoreboardLine currentLine = line.getLine(this.lines);
        PlayerScoreboardTemporaryLine newLine = null;
        newLine = currentLine != null ? new PlayerScoreboardTemporaryLine(this.scoreboardPlayer.getPlayer(), update, currentLine.getScoreAttribute(), currentLine.isRandom(), this.asList(tag.getLine(this.scoreboardPlayer.getPlayer())), time, currentLine) : new PlayerScoreboardTemporaryLine(this.scoreboardPlayer.getPlayer(), update, new ConfigAttribute(this.scoreboardPlayer.getObjectiveName(), AttributeType.INTEGER, "" + line.getDefaultScore()), false, this.asList(tag.getLine(this.scoreboardPlayer.getPlayer())), time, null);
        this.replace(currentLine, newLine);
    }

    private void replace(PlayerScoreboardLine currentLine, PlayerScoreboardTemporaryLine newLine) {
        if (currentLine != null) {
            newLine.setTeamColorName(currentLine.getTeamColorName());
            Collections.replaceAll(this.lines, currentLine, newLine);
            this.forceUpdate();
            return;
        }
        this.lines.add(newLine);
        this.forceUpdate();
    }

    private int findFreeColor() {
        for (int current = 0; current < ChatColor.values().length; ++current) {
            boolean match = false;
            for (PlayerScoreboardLine line : this.lines) {
                if (line.getTeamColorName() != current) continue;
                match = true;
            }
            if (match) continue;
            return current;
        }
        return 0;
    }

    private String[] splitString(String string) {
        if (string == null || string.trim().isEmpty()) {
            return new String[]{" ", " "};
        }
        if (!this.hasMaxLength()) {
            if (string.length() >= 15000) {
                return new String[]{string.substring(0, 15000), ""};
            }
            return new String[]{string, ""};
        }
        int suffixLength = ServerVersion.current().getScoreboardLength();
        int prefixLength = this.forceLegacy ? suffixLength - 2 : suffixLength;
        StringBuilder prefix = new StringBuilder(string.substring(0, string.length() >= prefixLength ? prefixLength : string.length()));
        StringBuilder suffix = new StringBuilder(string.length() > prefixLength ? string.substring(prefixLength) : "");
        if (prefix.charAt(prefix.length() - 1) == '\u00a7') {
            suffix = suffix.insert(0, '\u00a7');
            prefix = prefix.deleteCharAt(prefix.length() - 1);
        }
        if (suffix.length() > 0) {
            boolean applyColor = true;
            if (suffix.charAt(0) == '\u00a7' && suffix.length() >= 2) {
                ChatColor chatColor = ChatColor.getByChar((char)suffix.charAt(1));
                boolean bl = applyColor = chatColor == null || chatColor.isFormat();
            }
            if (applyColor) {
                String colors = ChatColor.getLastColors((String)prefix.toString());
                suffix = suffix.insert(0, colors);
            }
        }
        if (suffix.length() >= suffixLength && (suffix = new StringBuilder(suffix.substring(0, suffixLength))).charAt(suffix.length() - 1) == '\u00a7') {
            suffix = suffix.deleteCharAt(suffix.length() - 1);
        }
        if (this.forceLegacy) {
            return new String[]{prefix.append(ChatColor.WHITE).toString(), suffix.toString()};
        }
        return new String[]{prefix.toString(), suffix.toString()};
    }

    private String toMemberName(int color) {
        return MEMBER_PREFIX + ChatColor.values()[color] + ChatColor.RESET;
    }

    private boolean hasMaxLength() {
        return this.forceLegacy || this.legacyServer;
    }

    public String getName() {
        return this.name;
    }

    public ScoreboardPlayer getScoreboardPlayer() {
        return this.scoreboardPlayer;
    }

    public ScoreboardState getState() {
        return this.state;
    }

    public boolean isLegacyServer() {
        return this.legacyServer;
    }

    public boolean isForceLegacy() {
        return this.forceLegacy;
    }
}

