/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.listeners;

import me.jasperjh.animatedscoreboard.core.PlayerScoreboardHandler;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ScoreboardListener
implements Listener {
    private final PlayerScoreboardHandler scoreboardHandler;

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        this.scoreboardHandler.registerPlayer(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.scoreboardHandler.removePlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onKick(PlayerKickEvent event) {
        this.scoreboardHandler.removePlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.scoreboardHandler.updatePlayer(event.getPlayer());
    }

    public ScoreboardListener(PlayerScoreboardHandler scoreboardHandler) {
        this.scoreboardHandler = scoreboardHandler;
    }
}

