/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.hooks.placeholders;

import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.config.PluginConfig;
import me.jasperjh.animatedscoreboard.hooks.PluginHook;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlaceholderAPIHook
extends PluginHook {
    private PAPIExpansion expansion;

    public PlaceholderAPIHook(AnimatedScoreboard plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "PlaceholderAPI (ASB placeholders)";
    }

    @Override
    public boolean canEnable() {
        return Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    @Override
    public void enable() {
        this.expansion = new PAPIExpansion();
        this.expansion.register();
    }

    @Override
    public void reload() {
        this.expansion.reload();
    }

    private final class PAPIExpansion
    extends PlaceholderExpansion {
        private String noScoreboard;
        private String scoreboardEnabled;
        private String scoreboardDisabled;
        private Map<String, String> scoreboardNames;

        private PAPIExpansion() {
        }

        public boolean persist() {
            return true;
        }

        public boolean canRegister() {
            return true;
        }

        public String getAuthor() {
            return "JasperJH";
        }

        public String getIdentifier() {
            return "animatedscoreboard";
        }

        public String getVersion() {
            return "0.0.1";
        }

        public String onRequest(OfflinePlayer p, String identifier) {
            switch (identifier) {
                case "enabled": {
                    return PlaceholderAPIHook.this.plugin.getScoreboardHandler().hasScoreboardEnabled(p.getUniqueId()) ? this.scoreboardEnabled : this.scoreboardDisabled;
                }
                case "scoreboard": {
                    ScoreboardPlayer scoreboardPlayer = PlaceholderAPIHook.this.plugin.getScoreboardHandler().getPlayer(p.getUniqueId());
                    if (scoreboardPlayer == null || !scoreboardPlayer.isScoreboardEnabled() || !scoreboardPlayer.hasScoreboard()) {
                        return this.noScoreboard;
                    }
                    String name = scoreboardPlayer.getScoreboard().getName();
                    return this.scoreboardNames.getOrDefault(name, name.replace('_', ' '));
                }
            }
            return null;
        }

        private Map<String, Object> getDefaults() {
            HashMap<String, Object> defaults = new HashMap<String, Object>();
            defaults.put("scoreboard.none-active", "&7None");
            defaults.put("scoreboard.enabled", "&aEnabled");
            defaults.put("scoreboard.disabled", "&cDisabled");
            for (String name : PlaceholderAPIHook.this.plugin.getScoreboardHandler().getScoreboardNames()) {
                defaults.put("scoreboard.names." + name, name.replace('_', ' '));
            }
            return defaults;
        }

        public boolean register() {
            this.reload();
            return super.register();
        }

        private void reload() {
            PluginConfig config = new PluginConfig(PlaceholderAPIHook.this.plugin, "placeholders");
            Map<String, Object> defaults = this.getDefaults();
            for (Map.Entry<String, Object> entry : defaults.entrySet()) {
                if (config.contains(entry.getKey())) continue;
                config.set(entry.getKey(), entry.getValue());
            }
            this.noScoreboard = config.getString("scoreboard.none-active", "&7None");
            this.scoreboardEnabled = config.getString("scoreboard.enabled", "&aEnabled");
            this.scoreboardDisabled = config.getString("scoreboard.disabled", "&cDisabled");
            this.scoreboardNames = new HashMap<String, String>();
            for (String name : PlaceholderAPIHook.this.plugin.getScoreboardHandler().getScoreboardNames()) {
                this.scoreboardNames.put(name, config.getString("scoreboard.names." + name, name.replace('_', ' ')));
            }
            config.saveConfig();
        }
    }
}

