/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.hooks.permission;

import java.util.UUID;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.hooks.PluginHook;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.event.group.GroupDataRecalculateEvent;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import net.luckperms.api.model.user.User;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LuckPermsHook
extends PluginHook {
    public LuckPermsHook(AnimatedScoreboard plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "LuckPerms";
    }

    @Override
    public boolean canEnable() {
        return Bukkit.getPluginManager().isPluginEnabled(this.getName());
    }

    @Override
    public void enable() {
        LuckPerms luckPerms = LuckPermsProvider.get();
        luckPerms.getEventBus().subscribe((Object)this.plugin, UserDataRecalculateEvent.class, this::onUserDataRecalculate);
        luckPerms.getEventBus().subscribe((Object)this.plugin, GroupDataRecalculateEvent.class, this::onGroupDataRecalculate);
    }

    private void onUserDataRecalculate(UserDataRecalculateEvent event) {
        User user = event.getUser();
        Player player = Bukkit.getPlayer((UUID)user.getUniqueId());
        if (player == null || !player.isOnline()) {
            return;
        }
        ScoreboardPlayer scoreboardPlayer = this.plugin.getScoreboardHandler().getPlayer(player);
        if (scoreboardPlayer != null) {
            scoreboardPlayer.recalculateScoreboard(player.getWorld());
        }
    }

    private void onGroupDataRecalculate(GroupDataRecalculateEvent event) {
        String permission = "group." + event.getGroup().getName();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                ScoreboardPlayer scoreboardPlayer;
                if (!player.hasPermission(permission) || (scoreboardPlayer = this.plugin.getScoreboardHandler().getPlayer(player)) == null) continue;
                scoreboardPlayer.recalculateScoreboard(player.getWorld());
            }
        });
    }
}

