/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.enums;

import me.jasperjh.animatedscoreboard.storage.FileStorage;
import me.jasperjh.animatedscoreboard.storage.PlayerStorage;
import me.jasperjh.animatedscoreboard.storage.SQLiteStorage;

public enum StorageType {
    SQLITE(new SQLiteStorage()),
    YAML(new FileStorage());

    private final PlayerStorage playerStorage;

    public static StorageType getStorage(String name) {
        for (StorageType type : StorageType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    private StorageType(PlayerStorage playerStorage) {
        this.playerStorage = playerStorage;
    }

    public PlayerStorage getPlayerStorage() {
        return this.playerStorage;
    }
}

