/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.enums;

import me.jasperjh.animatedscoreboard.enums.ConfigSetting;
import org.bukkit.Bukkit;

public enum ServerVersion {
    v1_7(16, true, false),
    v1_8(16, true),
    v1_9(16, true),
    v1_10(16, true),
    v1_11(16, true),
    v1_12(16, true),
    v1_13(64, false),
    v1_14(64, false),
    v1_15(64, false),
    v1_16(64, false),
    v1_17(64, false),
    v1_18(64, false),
    v1_19(64, false),
    v1_20(64, false),
    UNKNOWN(64, false, false);

    private final int scoreboardLength;
    private final int titleLength;
    private final boolean legacy;
    private final boolean fullySupported;
    private static ServerVersion currentVersion;
    private static String version;

    private ServerVersion(int scoreboardLength, boolean legacy) {
        this(scoreboardLength, legacy, true);
    }

    private ServerVersion(int scoreboardLength, boolean legacy, boolean fullySupported) {
        this(scoreboardLength, scoreboardLength * 2, legacy, fullySupported);
    }

    private ServerVersion(int scoreboardLength, int titleLength, boolean legacy, boolean fullySupported) {
        this.scoreboardLength = scoreboardLength;
        this.titleLength = titleLength;
        this.legacy = legacy;
        this.fullySupported = fullySupported;
    }

    public boolean isNewerThanOrEqualTo(ServerVersion version) {
        if (this == UNKNOWN || version == UNKNOWN) {
            return false;
        }
        return this.ordinal() >= version.ordinal();
    }

    public int getTitleLength() {
        if (ConfigSetting.FORCE_LEGACY.getValue() && !this.isLegacy()) {
            return ServerVersion.v1_12.titleLength;
        }
        return this.titleLength;
    }

    public int getScoreboardLength() {
        if (ConfigSetting.FORCE_LEGACY.getValue() && !this.isLegacy()) {
            return ServerVersion.v1_12.scoreboardLength;
        }
        return this.scoreboardLength;
    }

    public String getScoreboardActionClass() {
        return this.isNewerThanOrEqualTo(v1_13) ? "ScoreboardServer$Action" : "PacketPlayOutScoreboardScore$EnumScoreboardAction";
    }

    public String getScoreboardColorField() {
        return this.isLegacy() || this.isNewerThanOrEqualTo(v1_17) ? null : "g";
    }

    public String getScoreboardNamesField() {
        if (this.isNewerThanOrEqualTo(v1_17)) {
            return "j";
        }
        return this.isNewerThanOrEqualTo(v1_9) ? "h" : "g";
    }

    public String getScoreboardModeField() {
        return this.isNewerThanOrEqualTo(v1_9) && !this.isNewerThanOrEqualTo(v1_17) ? "i" : "h";
    }

    public String getScoreboardOptionsField() {
        return this.isNewerThanOrEqualTo(v1_9) ? "j" : "i";
    }

    public String getScoreboardCollisionField() {
        return this.isNewerThanOrEqualTo(v1_9) ? "f" : null;
    }

    public String getScoreboardObjectiveNameField() {
        return this.isNewerThanOrEqualTo(v1_17) ? "d" : "a";
    }

    public String getScoreboardObjectiveDisplayNameField() {
        return this.isNewerThanOrEqualTo(v1_17) ? "e" : "b";
    }

    public String getScoreboardObjectiveHealthDisplayField() {
        return this.isNewerThanOrEqualTo(v1_17) ? "f" : "c";
    }

    public String getScoreboardObjectiveModeField() {
        return this.isNewerThanOrEqualTo(v1_17) ? "g" : "d";
    }

    public String getScoreboardTeamNameField() {
        return this.isNewerThanOrEqualTo(v1_17) ? "i" : "a";
    }

    public String getScoreboardTeamDisplayNameField() {
        return this.isNewerThanOrEqualTo(v1_17) ? null : "b";
    }

    public String getScoreboardTeamPrefixField() {
        return this.isNewerThanOrEqualTo(v1_17) ? null : "c";
    }

    public String getScoreboardTeamSuffixField() {
        return this.isNewerThanOrEqualTo(v1_17) ? null : "d";
    }

    public String getScoreboardTeamDataField() {
        return this.isNewerThanOrEqualTo(v1_17) ? "k" : null;
    }

    public static ServerVersion current() {
        if (currentVersion != null) {
            return currentVersion;
        }
        version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        for (ServerVersion serverVersion : ServerVersion.values()) {
            if (!version.contains(serverVersion.name())) continue;
            currentVersion = serverVersion;
            break;
        }
        if (currentVersion == null) {
            currentVersion = UNKNOWN;
        }
        return currentVersion;
    }

    public String getExactVersion() {
        if (currentVersion == null) {
            ServerVersion.current();
        }
        return version;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean isFullySupported() {
        return this.fullySupported;
    }
}

