/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.enums;

import java.util.List;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.config.PlayerScoreboardFile;
import me.jasperjh.animatedscoreboard.objects.format.FileSyntax;
import me.jasperjh.animatedscoreboard.objects.format.FormattedLine;
import me.jasperjh.animatedscoreboard.objects.format.syntax.CompactListSyntax;
import me.jasperjh.animatedscoreboard.objects.format.syntax.ExpandedListSyntax;
import me.jasperjh.animatedscoreboard.objects.format.syntax.ExpandedSyntax;

public enum ScoreboardFormat {
    EXPANDED_SYNTAX(new ExpandedSyntax()),
    COMPACT_LIST_SYNTAX(new CompactListSyntax()),
    EXPANDED_LIST_SYNTAX(new ExpandedListSyntax());

    private final FileSyntax syntax;

    public List<FormattedLine> parse(PlayerScoreboardFile file) {
        AnimatedScoreboard.getInstance().log(Level.INFO, "Loading scoreboard {0} with {1} format!", file.getFileNameWithoutExtension(), this.name());
        return this.syntax.parse(file);
    }

    public static ScoreboardFormat getFormat(PlayerScoreboardFile file) {
        for (ScoreboardFormat format : ScoreboardFormat.values()) {
            if (!format.syntax.isApplicable(file)) continue;
            return format;
        }
        return null;
    }

    private ScoreboardFormat(FileSyntax syntax) {
        this.syntax = syntax;
    }
}

