/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.util.Strings;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public enum Messages {
    PREFIX("prefix", "&7[&cASB&7] "),
    NO_PERMISSION("nopermission", "%prefix&cYou don't have the right permission!"),
    TOGGLE_ON("toggle.on", "%prefix&aYou toggled the scoreboard &2on&a!"),
    TOGGLE_OFF("toggle.off", "%prefix&aYou toggled the scoreboard &coff&a!"),
    TOGGLE_ON_OTHER_TARGET("toggle.on_other_target", "%prefix&aYour scoreboard was toggled &2on&a by %sender%!"),
    TOGGLE_ON_OTHER_SENDER("toggle.on_other_sender", "%prefix&aYou toggle the scoreboard &2on&a for %target%!"),
    TOGGLE_OFF_OTHER_TARGET("toggle.off_other_target", "%prefix&aYour scoreboard was toggled &coff&a by %sender%!"),
    TOGGLE_OFF_OTHER_SENDER("toggle.off_other_sender", "%prefix&aYou toggle the scoreboard &coff&a for %target%!"),
    RELOAD_STARTING("reload.start", "%prefix&aReloading of the plugin started!"),
    RELOAD_COMPLETED("reload.completed", "%prefix&aReload completed! Done in %MS%ms!"),
    SWITCH_ERROR("switch.error", "%prefix&cPlease provide a valid scoreboard!"),
    SWITCH_SUCCESS("switch.success", "%prefix&aSwitched to scoreboard &2%scoreboard%&a!"),
    SWITCH_PERMISSION("switch.nopermission", "%prefix&cYou don't have the right permission to switch to %scoreboard%!"),
    SWITCH_WORLD("switch.world", "%prefix&cYou cannot activate this scoreboard in this world!"),
    SWITCH_ACTIVE("switch.already_activated", "%prefix&cYou already have this scoreboard active!"),
    SWITCH_ACTIVE_OTHER("switch.already_active_other", "%prefix&c%target% already has %scoreboard% active!"),
    SWITCH_SUCCESS_OTHER("switch.success_other", "%prefix&aSuccessfully switched the scoreboard of %target% to %scoreboard%!"),
    SWITCHED_BY_OTHER("switch.success_by_other", "%prefix&aYour scoreboard was switched by %sender%!"),
    SWITCH_WORLD_OTHER("switch.world_other", "%prefix&c%target% cannot activate %scoreboard% in their world!"),
    SWITCH_PERMISSION_OTHER("switch.nopermission_other", "%prefix&c%target% doesn't have the permission to view %scoreboard%!"),
    TRIGGER_INSERT("trigger.insert", "%prefix&cFailed to insert the trigger listener, triggers will not work!"),
    TRIGGER_REGISTER_INVALID("trigger.register.invalid", "%prefix&cFailed to activate trigger for class: %class_name%, Invalid class name!"),
    TRIGGER_REGISTER_SECOND("trigger.register.second", "%prefix&cFailed to activate trigger for class: %class_name%, Trigger already active!"),
    TRIGGER_REGISTER_METHOD("trigger.register.invalid-method", "%prefix&cFailed to activate trigger for class: %class_name%, Invalid method name!"),
    INFORMATION("plugin.information", "%prefix&aThis server is running animated scoreboard version &2%version%&a!"),
    INVALID_PLAYER("invalid_player", "%prefix&c%value% is not a valid player name or not online!"),
    INVALID_COMMAND("invalid_command", "%prefix&c'/%command%' is not a valid command. Try '/asb help' for commands!"),
    ONLY_PLAYER("invalid_sender", "%prefix&cThis command can only be executed by a player!");

    private String path;
    private Object defaultMessage;
    private List<String> message;

    private Messages(String path, String defaultMessage) {
        this.path = path;
        this.defaultMessage = defaultMessage;
        this.setMessage(defaultMessage);
    }

    private Messages(String path, List<String> defaultMessage) {
        this.path = path;
        this.defaultMessage = defaultMessage;
        this.setMessage(defaultMessage);
    }

    private void setMessage(Object defaultMessage) {
        AnimatedScoreboard plugin = (AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class);
        Object messageObject = plugin.getMessagesFile().get(this.path);
        if (messageObject == null) {
            plugin.getMessagesFile().set(this.path, defaultMessage);
            messageObject = defaultMessage;
        }
        if (messageObject instanceof List) {
            ArrayList<String> messages = new ArrayList<String>();
            for (String s : (List)messageObject) {
                s = Strings.parseColors(s);
                messages.add(s);
            }
            this.message = messages;
        } else if (messageObject instanceof String) {
            this.message = Arrays.asList(Strings.parseColors((String)messageObject));
        }
    }

    public void send(CommandSender sender, String ... format) {
        if (this.isEmpty()) {
            return;
        }
        for (String messageText : this.message) {
            for (int i = 0; i < format.length; i += 2) {
                messageText = messageText.replaceAll(format[i], format[i + 1]);
            }
            sender.sendMessage(messageText.replaceAll("%prefix", Messages.PREFIX.message.get(0)));
        }
    }

    public void log(AnimatedScoreboard plugin, Level level, String ... format) {
        if (this.isEmpty()) {
            return;
        }
        for (String messageText : this.message) {
            for (int i = 0; i < format.length; i += 2) {
                messageText = messageText.replaceAll(format[i], format[i + 1]);
            }
            plugin.log(level, messageText.replace("%prefix", ""), new Object[0]);
        }
    }

    private boolean isEmpty() {
        return this.message == null || this.message.isEmpty() || !this.message.stream().filter(m -> !m.isEmpty()).findAny().isPresent();
    }

    public static void reloadMessages() {
        for (Messages message : Messages.values()) {
            message.setMessage(message.defaultMessage);
        }
    }
}

