/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.enums;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.display.attribute.ConfigAttribute;
import me.jasperjh.animatedscoreboard.display.attribute.TagAttributes;
import me.jasperjh.animatedscoreboard.display.tag.DefaultTag;
import me.jasperjh.animatedscoreboard.display.tag.GradientTag;
import me.jasperjh.animatedscoreboard.display.tag.HealthTag;
import me.jasperjh.animatedscoreboard.display.tag.RepeatTag;
import me.jasperjh.animatedscoreboard.display.tag.ScrollTag;
import me.jasperjh.animatedscoreboard.display.tag.StayTag;
import me.jasperjh.animatedscoreboard.display.tag.UpdateTag;
import me.jasperjh.animatedscoreboard.enums.AttributeType;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTag;
import me.jasperjh.animatedscoreboard.util.Strings;

public enum LineType {
    DEFAULT("", false, false, DefaultTag.class, new ConfigAttribute[0]),
    REPEAT("repeat", false, false, RepeatTag.class, new ConfigAttribute("times", AttributeType.DOUBLE, "5")),
    SCROLL("scroll", true, true, ScrollTag.class, new ConfigAttribute("space", AttributeType.INTEGER, "5"), new ConfigAttribute("width", AttributeType.INTEGER, "16"), new ConfigAttribute("update", AttributeType.INTEGER, "20")),
    STAY("stay", false, true, StayTag.class, new ConfigAttribute("ticks", AttributeType.INTEGER, "5")),
    UPDATE("update", true, true, UpdateTag.class, new ConfigAttribute("ticks", AttributeType.INTEGER, "5"), new ConfigAttribute("stay", AttributeType.INTEGER, "60")),
    HEALTH("health", true, false, HealthTag.class, new ConfigAttribute("full", AttributeType.STRING, "&4"), new ConfigAttribute("half", AttributeType.STRING, "&c"), new ConfigAttribute("empty", AttributeType.STRING, "&f"), new ConfigAttribute("update", AttributeType.INTEGER, "5")),
    GRADIENT("gradient", false, false, GradientTag.class, new ConfigAttribute("start", AttributeType.STRING, "&#ffffff"), new ConfigAttribute("end", AttributeType.STRING, "&#000000"));

    private String name;
    private Constructor<?> constructor;
    private ConfigAttribute[] attributes;
    private boolean shouldOverrideUpdate;
    private boolean shouldOverrideStay;

    private LineType(String name, boolean overrideUpdate, boolean overrideStay, Class<?> tagClass, ConfigAttribute ... attributes) {
        this.name = name;
        this.attributes = attributes;
        this.shouldOverrideUpdate = overrideUpdate;
        this.shouldOverrideStay = overrideStay;
        try {
            this.constructor = tagClass.getConstructors()[0];
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public ConfigAttribute[] getAttributes() {
        ConfigAttribute[] array = new ConfigAttribute[this.attributes.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.attributes[i].clone();
        }
        return array;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public PlayerScoreboardTag newTag(AnimatedScoreboard plugin, TagAttributes tagAttributes, String text) {
        text = this.prepareText(text);
        boolean containsPlaceholders = plugin.getPlaceholderHandler().containsPlaceholders(text);
        try {
            if (this != DEFAULT) {
                return (PlayerScoreboardTag)this.constructor.newInstance(tagAttributes, text, containsPlaceholders);
            }
            return (PlayerScoreboardTag)this.constructor.newInstance(text, containsPlaceholders);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return new DefaultTag(text, containsPlaceholders);
        }
    }

    public TagAttributes newAttributes() {
        return new TagAttributes(this);
    }

    private String prepareText(String text) {
        return Strings.parseColors(text);
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldOverrideUpdate() {
        return this.shouldOverrideUpdate;
    }

    public boolean shouldOverrideStay() {
        return this.shouldOverrideStay;
    }
}

