/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardLine;

public enum Line {
    TITLE{

        @Override
        public PlayerScoreboardLine getLine(List<PlayerScoreboardLine> lines) {
            return lines.get(0);
        }

        @Override
        public int getDefaultScore() {
            return 0;
        }
    }
    ,
    HIGHEST{

        @Override
        public PlayerScoreboardLine getLine(List<PlayerScoreboardLine> lines) {
            return Collections.max(lines.subList(1, lines.size()), Comparator.comparing(PlayerScoreboardLine::getCurrentScore));
        }

        @Override
        public int getDefaultScore() {
            return 999;
        }
    }
    ,
    LOWEST{

        @Override
        public PlayerScoreboardLine getLine(List<PlayerScoreboardLine> lines) {
            return Collections.min(lines.subList(1, lines.size()), Comparator.comparing(PlayerScoreboardLine::getCurrentScore));
        }

        @Override
        public int getDefaultScore() {
            return -999;
        }
    }
    ,
    LINE_1(1),
    LINE_2(2),
    LINE_3(3),
    LINE_4(4),
    LINE_5(5),
    LINE_6(6),
    LINE_7(7),
    LINE_8(8),
    LINE_9(9),
    LINE_10(10),
    LINE_11(11),
    LINE_12(12),
    LINE_13(13),
    LINE_14(14),
    LINE_15(15);

    private final int score;

    private Line() {
        this.score = 0;
    }

    private Line(int score) {
        this.score = score;
    }

    public PlayerScoreboardLine getLine(List<PlayerScoreboardLine> lines) {
        if (lines.size() <= this.score) {
            return null;
        }
        ArrayList copy = Lists.newArrayList(lines.subList(1, lines.size()));
        Collections.sort(copy, Comparator.comparing(PlayerScoreboardLine::getCurrentScore));
        return (PlayerScoreboardLine)copy.get(this.score - 1);
    }

    public int getDefaultScore() {
        return this.score;
    }
}

