/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.enums;

import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.display.attribute.parser.DefaultParser;
import me.jasperjh.animatedscoreboard.display.attribute.parser.StringParser;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public enum AttributeType {
    BOOLEAN(false, Boolean.class),
    BYTE(false, Byte.class),
    INTEGER(false, Integer.class),
    LONG(false, Long.class),
    SHORT(false, Short.class),
    FLOAT(false, Float.class),
    DOUBLE(false, Double.class),
    STRING(false, String.class),
    PLACEHOLDER_BOOLEAN(true),
    PLACEHOLDER_BYTE(true),
    PLACEHOLDER_INTEGER(true),
    PLACEHOLDER_LONG(true),
    PLACEHOLDER_SHORT(true),
    PLACEHOLDER_FLOAT(true),
    PLACEHOLDER_DOUBLE(true),
    PLACEHOLDER_STRING(true);

    private boolean placeholder;
    private DefaultParser<?> parser;
    private AnimatedScoreboard plugin = (AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class);

    private AttributeType(boolean placeholder, Class<?> parserType) {
        this.placeholder = placeholder;
        this.parser = StringParser.getParser(parserType);
    }

    private AttributeType(boolean placeholder) {
        this.placeholder = placeholder;
    }

    public <T> T parse(Player player, String value) {
        if (this.parser == null) {
            value = this.plugin.getPlaceholderHandler().replacePlaceholders(player, value);
            return this.getNormalType().parse(player, value);
        }
        return (T)this.parser.parse(value);
    }

    public AttributeType getPlaceholderType() {
        int ordinal;
        int placeHolderType;
        AttributeType[] values = AttributeType.values();
        if (values.length <= (placeHolderType = (ordinal = this.ordinal()) + 8)) {
            return this;
        }
        return values[placeHolderType];
    }

    public AttributeType getNormalType() {
        AttributeType[] values = AttributeType.values();
        int ordinal = this.ordinal();
        int normalType = ordinal - 8;
        if (normalType < 0) {
            return this;
        }
        return values[normalType];
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public DefaultParser<?> getParser() {
        return this.parser;
    }

    public AnimatedScoreboard getPlugin() {
        return this.plugin;
    }
}

