/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.display.attribute.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.display.attribute.parser.DefaultParser;
import me.jasperjh.animatedscoreboard.display.attribute.parser.PrimitiveParser;
import org.bukkit.plugin.java.JavaPlugin;

public class StringParser {
    private static final Map<Class<?>, DefaultParser<?>> DEFAULT_PRIMITIVE_PARSERS = new HashMap();
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new HashMap();

    public static <T> T parse(String value, Class<?> type) {
        if (!type.isPrimitive() && WRAPPER_TO_PRIMITIVE.containsKey(type)) {
            type = WRAPPER_TO_PRIMITIVE.get(type);
        }
        if (value.trim().equalsIgnoreCase("null") || type == null) {
            return null;
        }
        T result = null;
        try {
            if (DEFAULT_PRIMITIVE_PARSERS.containsKey(type)) {
                result = (T)DEFAULT_PRIMITIVE_PARSERS.get(type).parse(value);
            }
        }
        catch (Exception exception) {
            if (DEFAULT_PRIMITIVE_PARSERS.containsKey(type)) {
                result = (T)DEFAULT_PRIMITIVE_PARSERS.get(type).parse("0");
            }
            ((AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class)).getLogger().log(Level.SEVERE, "Couldn't parse " + value + " to " + type.getName() + " refering to default 0.");
            exception.printStackTrace();
        }
        return result;
    }

    public static DefaultParser<?> getParser(Class<?> type) {
        DefaultParser<?> parser = null;
        if (!type.isPrimitive() && WRAPPER_TO_PRIMITIVE.containsKey(type)) {
            type = WRAPPER_TO_PRIMITIVE.get(type);
        }
        if (type == null) {
            return null;
        }
        if (DEFAULT_PRIMITIVE_PARSERS.containsKey(type)) {
            parser = DEFAULT_PRIMITIVE_PARSERS.get(type);
        }
        return parser;
    }

    static {
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        for (DefaultParser<?> typeParser : PrimitiveParser.getPARSERS()) {
            Class<?> type = typeParser.getParsedType();
            if (WRAPPER_TO_PRIMITIVE.containsKey(type)) {
                DEFAULT_PRIMITIVE_PARSERS.put(WRAPPER_TO_PRIMITIVE.get(type), typeParser);
                continue;
            }
            DEFAULT_PRIMITIVE_PARSERS.put(type, typeParser);
        }
    }
}

