/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.display.attribute.parser;

import java.util.ArrayList;
import java.util.List;
import me.jasperjh.animatedscoreboard.display.attribute.parser.DefaultParser;

public class PrimitiveParser {
    private static final List<DefaultParser<?>> PARSERS = new ArrayList();
    private static final String MESSAGE = "%s is not parsable to a %s!";

    public static List<DefaultParser<?>> getPARSERS() {
        return PARSERS;
    }

    static {
        for (Class<?> c : PrimitiveParser.class.getDeclaredClasses()) {
            if (!DefaultParser.class.isAssignableFrom(c)) continue;
            try {
                DefaultParser instance = (DefaultParser)c.newInstance();
                PARSERS.add(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class StringTypeParser
    implements DefaultParser<String> {
        StringTypeParser() {
        }

        @Override
        public String parse(String value) {
            return value;
        }

        @Override
        public Class<String> getParsedType() {
            return String.class;
        }
    }

    static class DoubleTypeParser
    implements DefaultParser<Double> {
        DoubleTypeParser() {
        }

        @Override
        public Double parse(String value) {
            return Double.valueOf(value);
        }

        @Override
        public Class<Double> getParsedType() {
            return Double.class;
        }
    }

    static class FloatTypeParser
    implements DefaultParser<Float> {
        FloatTypeParser() {
        }

        @Override
        public Float parse(String value) {
            return Float.valueOf(value);
        }

        @Override
        public Class<Float> getParsedType() {
            return Float.class;
        }
    }

    static class ShortTypeParser
    implements DefaultParser<Short> {
        ShortTypeParser() {
        }

        @Override
        public Short parse(String value) {
            return Short.valueOf(value.trim());
        }

        @Override
        public Class<Short> getParsedType() {
            return Short.class;
        }
    }

    static class LongTypeParser
    implements DefaultParser<Long> {
        LongTypeParser() {
        }

        @Override
        public Long parse(String value) {
            return Long.valueOf(value.trim());
        }

        @Override
        public Class<Long> getParsedType() {
            return Long.class;
        }
    }

    static class IntegerTypeParser
    implements DefaultParser<Integer> {
        IntegerTypeParser() {
        }

        @Override
        public Integer parse(String value) {
            return Integer.valueOf(value.trim());
        }

        @Override
        public Class<Integer> getParsedType() {
            return Integer.class;
        }
    }

    static class ByteTypeParser
    implements DefaultParser<Byte> {
        ByteTypeParser() {
        }

        @Override
        public Byte parse(String value) {
            return Byte.valueOf(value.trim());
        }

        @Override
        public Class<Byte> getParsedType() {
            return Byte.class;
        }
    }

    static class BooleanTypeParser
    implements DefaultParser<Boolean> {
        BooleanTypeParser() {
        }

        @Override
        public Boolean parse(String bool) {
            String value = bool.trim().toLowerCase();
            if (value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException(String.format(PrimitiveParser.MESSAGE, bool, "boolean"));
        }

        @Override
        public Class<Boolean> getParsedType() {
            return Boolean.class;
        }
    }
}

