/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.display.attribute;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.jasperjh.animatedscoreboard.display.attribute.ConfigAttribute;
import me.jasperjh.animatedscoreboard.enums.LineType;
import org.bukkit.entity.Player;

public class TagAttributes {
    private List<ConfigAttribute> values;

    public TagAttributes(LineType type) {
        if (type.hasAttributes()) {
            this.values = Lists.newArrayList();
            Collections.addAll(this.values, type.getAttributes());
        }
    }

    public void applyValue(String attribute, String value) {
        this.applyValue(this.getAttribute(attribute), value);
    }

    public void applyValue(ConfigAttribute attribute, String value) {
        if (value == null || !this.values.contains(attribute)) {
            return;
        }
        attribute.setValue(value);
    }

    public ConfigAttribute getAttribute(String name) {
        for (ConfigAttribute attribute : this.values) {
            if (!attribute.getName().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        return null;
    }

    public String getValue(String name) {
        ConfigAttribute attribute = this.getAttribute(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public <T> T getParsedValue(Player player, String name) {
        ConfigAttribute attribute = this.getAttribute(name);
        return attribute.getType().parse(player, attribute.getValue(player));
    }
}

