/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.display;

import me.jasperjh.animatedscoreboard.display.attribute.TagAttributes;
import me.jasperjh.animatedscoreboard.enums.LineType;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardDisplayLine;
import org.bukkit.entity.Player;

public class UpdateLine
extends PlayerScoreboardDisplayLine {
    private Player player;
    private TagAttributes attributes;
    private String text;
    private int currentTime;
    private int currentStay;

    public UpdateLine(Player player, TagAttributes attributes, String text, boolean placeholders) {
        super(placeholders, LineType.UPDATE);
        this.player = player;
        this.attributes = attributes;
        this.text = text;
    }

    @Override
    public boolean shouldStay() {
        if (this.currentStay++ == (Integer)this.attributes.getParsedValue(this.player, "stay")) {
            this.currentStay = 0;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldUpdate() {
        ++this.currentTime;
        if (this.currentTime == (Integer)this.attributes.getParsedValue(this.player, "ticks")) {
            this.currentTime = 0;
            return true;
        }
        return false;
    }

    @Override
    public String update() {
        return this.text;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void removeAll() {
        this.player = null;
        this.attributes = null;
        this.text = null;
    }
}

