/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.display;

import me.jasperjh.animatedscoreboard.display.attribute.TagAttributes;
import me.jasperjh.animatedscoreboard.enums.LineType;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardDisplayLine;
import org.bukkit.entity.Player;

public class StayLine
extends PlayerScoreboardDisplayLine {
    private Player player;
    private TagAttributes attributes;
    private String text;
    private int currentTime;

    public StayLine(Player player, TagAttributes attributes, String text, boolean placeholders) {
        super(placeholders, LineType.STAY);
        this.player = player;
        this.attributes = attributes;
        this.text = text;
    }

    @Override
    public boolean shouldStay() {
        if (this.currentTime == (Integer)this.attributes.getParsedValue(this.player, "ticks")) {
            this.currentTime = 0;
            return false;
        }
        ++this.currentTime;
        return true;
    }

    @Override
    public boolean shouldUpdate() {
        return false;
    }

    @Override
    public String update() {
        return this.text;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void removeAll() {
        this.player = null;
        this.attributes = null;
        this.text = null;
    }
}

