/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.display;

import java.util.Map;
import java.util.TreeMap;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.display.attribute.TagAttributes;
import me.jasperjh.animatedscoreboard.enums.LineType;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardDisplayLine;
import me.jasperjh.animatedscoreboard.util.Strings;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ScrollLine
extends PlayerScoreboardDisplayLine {
    private Player player;
    private TagAttributes attributes;
    private String[] lines;
    private int max;
    private int currentTime;
    private int currentFrame;
    private TreeMap<Integer, String> colorMap = new TreeMap();

    public ScrollLine(Player player, TagAttributes attributes, String scrollText, boolean placeholders) {
        super(placeholders, LineType.SCROLL);
        this.player = player;
        this.attributes = attributes;
        int width = (Integer)attributes.getParsedValue(player, "width");
        int space = (Integer)attributes.getParsedValue(player, "space");
        scrollText = ((AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class)).getPlaceholderHandler().replacePlaceholders(player, scrollText);
        scrollText = this.scanColors(scrollText);
        this.max = scrollText.length() + space;
        this.lines = new String[this.max];
        for (int createFrame = 0; createFrame < this.max; ++createFrame) {
            int lastIndexOf;
            boolean importColors = true;
            String text = scrollText;
            int firstCut = 0;
            int lastCut = 0;
            if (createFrame <= text.length() - width) {
                firstCut = createFrame;
                lastCut = createFrame + width;
                text = text.substring(firstCut, lastCut);
            } else if (createFrame - (text.length() - width) < space) {
                firstCut = createFrame;
                lastCut = text.length();
                int spaces = createFrame - (text.length() - width);
                text = text.substring(firstCut, lastCut) + Strings.spaces(spaces < 0 ? 0 : spaces);
            } else if (createFrame < text.length()) {
                firstCut = createFrame;
                lastCut = text.length();
                text = text.substring(firstCut, lastCut) + Strings.spaces(space);
            } else {
                if (createFrame >= text.length() + space) break;
                int spaceWidth = text.length() + space - createFrame;
                firstCut = spaceWidth = spaceWidth > space ? space : spaceWidth;
                text = Strings.spaces(spaceWidth);
                importColors = false;
            }
            int length = text.length();
            if (importColors) {
                text = this.importColors(text, firstCut);
            }
            if (length < width) {
                text = text + this.getCopy(scrollText, width, space, length);
            }
            StringBuilder sb = new StringBuilder(text);
            char lastChar = text.charAt(firstCut - 1 >= 1 && firstCut < text.length() - 1 ? firstCut - 1 : 0);
            if (lastChar == '\u00a7') {
                sb.deleteCharAt(text.length() - 1);
            }
            if ((lastIndexOf = sb.lastIndexOf("\u00a7")) != -1) {
                if (lastIndexOf == text.length() - 1) {
                    sb.deleteCharAt(text.length() - 1);
                } else if (lastIndexOf == text.length() - 2) {
                    sb.delete(text.length() - 2, text.length());
                }
            }
            this.lines[createFrame] = sb.toString();
        }
        this.colorMap.clear();
        this.colorMap = null;
    }

    @Override
    public boolean shouldStay() {
        return true;
    }

    @Override
    public boolean shouldUpdate() {
        ++this.currentTime;
        if (this.currentTime == (Integer)this.attributes.getParsedValue(this.player, "update")) {
            this.currentTime = 0;
            if (++this.currentFrame >= this.max) {
                this.currentFrame = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public String update() {
        return this.lines[this.currentFrame];
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public String importColors(String text, int firstCut) {
        StringBuilder colors = new StringBuilder(text);
        try {
            this.colorMap.descendingKeySet().forEach(index -> {
                int cut = 0;
                if (index > 0) {
                    cut = index - firstCut;
                }
                if (cut > text.length()) {
                    return;
                }
                if (index < firstCut && colors.charAt(0) == '\u00a7') {
                    boolean colorCorrect;
                    Map.Entry<Integer, String> next = this.colorMap.tailMap((Integer)index, false).firstEntry();
                    if (next == null) {
                        return;
                    }
                    String colorCodes = next.getValue();
                    ChatColor colorCheck = ChatColor.getByChar((String)colorCodes.substring(1, 2));
                    boolean nextKey = next.getKey() <= firstCut;
                    boolean bl = colorCorrect = colorCheck.isColor() || colorCheck.equals((Object)ChatColor.RESET);
                    if (nextKey && colorCorrect) {
                        throw new RuntimeException();
                    }
                }
                if (cut < 0) {
                    cut = 0;
                }
                String color = this.colorMap.get(index);
                colors.insert(cut, color);
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return colors.toString();
    }

    public String scanColors(String text) {
        int index;
        if (text.indexOf(167) == -1) {
            return text;
        }
        StringBuilder scanner = new StringBuilder(text);
        int current = 0;
        while (current < scanner.length() && (index = scanner.indexOf("\u00a7", current)) != -1 && index < scanner.length() - 1) {
            char colorCode = scanner.charAt(index + 1);
            if (colorCode == 'x') {
                this.colorMap.merge(index, "\u00a7x", String::concat);
            } else {
                ChatColor color = ChatColor.getByChar((char)colorCode);
                if (color == null) {
                    current = index + 1;
                    continue;
                }
                this.colorMap.merge(index, color.toString(), String::concat);
            }
            scanner.delete(index, index + 2);
            current = index;
        }
        return scanner.toString();
    }

    public String getCopy(String msg, int width, int space, int currentLength) {
        String text = msg;
        int firstCut = 0;
        int lastCut = 0;
        if (text.length() + currentLength >= width) {
            firstCut = 0;
            lastCut = width - currentLength;
            lastCut = lastCut >= text.length() ? text.length() : lastCut;
            text = text.substring(firstCut, lastCut);
        } else {
            firstCut = 0;
            lastCut = width - currentLength;
            lastCut = lastCut >= text.length() ? text.length() : lastCut;
            int spaceWidth = currentLength + lastCut < width ? width - (currentLength + lastCut) : 0;
            spaceWidth = spaceWidth > space ? space : spaceWidth;
            text = text.substring(firstCut, lastCut) + Strings.spaces(spaceWidth);
        }
        int length = text.length() + currentLength;
        text = this.importColors(text, firstCut);
        if (length < width) {
            text = text + this.getCopy(msg, width, space, length);
        }
        return text;
    }

    @Override
    public void removeAll() {
        this.player = null;
        this.attributes = null;
        this.lines = null;
    }
}

