/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.display;

import com.google.common.base.Strings;
import me.jasperjh.animatedscoreboard.display.attribute.TagAttributes;
import me.jasperjh.animatedscoreboard.enums.LineType;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardDisplayLine;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;

public class HealthLine
extends PlayerScoreboardDisplayLine {
    private Player player;
    private TagAttributes attributes;
    private String text;
    private int currentTime;

    public HealthLine(Player player, TagAttributes attributes, String text, boolean placeholders) {
        super(placeholders, LineType.HEALTH);
        this.player = player;
        this.attributes = attributes;
        this.text = text;
    }

    @Override
    public boolean shouldStay() {
        return false;
    }

    @Override
    public boolean shouldUpdate() {
        ++this.currentTime;
        if (this.currentTime == (Integer)this.attributes.getParsedValue(this.player, "update")) {
            this.currentTime = 0;
            return true;
        }
        return false;
    }

    @Override
    public String update() {
        double health = this.player.getHealth() * 0.5;
        double max = this.player.getMaxHealth() * 0.5;
        if (max < health) {
            max = health;
        }
        String full = (String)this.attributes.getParsedValue(this.player, "full");
        String half = (String)this.attributes.getParsedValue(this.player, "half");
        String empty = (String)this.attributes.getParsedValue(this.player, "empty");
        StringBuilder builder = new StringBuilder();
        builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)full));
        builder.append(Strings.repeat((String)this.text, (int)((int)Math.floor(health))));
        if (health % 1.0 != 0.0) {
            builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)half));
            builder.append(Strings.repeat((String)this.text, (int)1));
        }
        builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)empty));
        builder.append(Strings.repeat((String)this.text, (int)((int)Math.floor(max - health))));
        return builder.toString();
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void removeAll() {
        this.player = null;
        this.attributes = null;
        this.text = null;
    }
}

