/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.display;

import java.awt.Color;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.core.PlaceholderHandler;
import me.jasperjh.animatedscoreboard.display.attribute.TagAttributes;
import me.jasperjh.animatedscoreboard.enums.LineType;
import me.jasperjh.animatedscoreboard.enums.PatternType;
import me.jasperjh.animatedscoreboard.enums.ServerVersion;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardDisplayLine;
import me.jasperjh.animatedscoreboard.util.Strings;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class GradientLine
extends PlayerScoreboardDisplayLine {
    private final PlaceholderHandler placeholderHandler = ((AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class)).getPlaceholderHandler();
    private Player player;
    private TagAttributes attributes;
    private final String plainText;
    private String lastPlainText;
    private String lastColoredText;
    private final Color startColor;
    private final Color endColor;

    public GradientLine(Player player, TagAttributes attributes, String text, boolean placeholders) {
        super(placeholders, LineType.GRADIENT);
        this.player = player;
        this.attributes = attributes;
        this.startColor = this.parseColor("start");
        this.endColor = this.parseColor("end");
        this.plainText = text;
    }

    @Override
    public boolean shouldStay() {
        return false;
    }

    @Override
    public boolean shouldUpdate() {
        return false;
    }

    @Override
    public String update() {
        if (this.lastPlainText == null || this.lastColoredText == null) {
            this.lastPlainText = this.placeholderHandler.replacePlaceholders(this.player, this.plainText);
            this.lastColoredText = this.parseText(this.lastPlainText);
            return this.lastColoredText;
        }
        if (!this.hasPlaceholders()) {
            return this.lastColoredText;
        }
        String newPlainText = this.placeholderHandler.replacePlaceholders(this.player, this.plainText);
        if (!this.lastPlainText.equals(newPlainText)) {
            this.lastPlainText = newPlainText;
            this.lastColoredText = this.parseText(this.lastPlainText);
        }
        return this.lastColoredText;
    }

    @Override
    public void removeAll() {
        this.player = null;
        this.lastPlainText = null;
        this.lastColoredText = null;
    }

    private String parseText(String text) {
        if (!ServerVersion.current().isNewerThanOrEqualTo(ServerVersion.v1_16)) {
            return text;
        }
        if (this.startColor == null || this.endColor == null) {
            return text;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<Integer, String> formatting = new HashMap<Integer, String>();
        StringBuilder currentColors = new StringBuilder();
        int colors = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\u00a7' && i < text.length() - 1 && ChatColor.getByChar((char)text.charAt(i + 1)) != null) {
                ChatColor color = ChatColor.getByChar((char)text.charAt(i + 1));
                if (color.equals((Object)ChatColor.RESET)) {
                    currentColors.setLength(0);
                } else if (Strings.isColor(color)) {
                    currentColors.setLength(0);
                    currentColors.append(color.toString());
                } else {
                    currentColors.append(color.toString());
                }
                formatting.put(i - colors, currentColors.toString());
                ++i;
                colors += 2;
                continue;
            }
            stringBuilder.append(text.charAt(i));
        }
        double textLength = stringBuilder.length();
        double redDiff = (double)(this.endColor.getRed() - this.startColor.getRed()) / textLength;
        double greenDiff = (double)(this.endColor.getGreen() - this.startColor.getGreen()) / textLength;
        double blueDiff = (double)(this.endColor.getBlue() - this.startColor.getBlue()) / textLength;
        char[] textArray = stringBuilder.toString().toCharArray();
        StringBuilder lineText = new StringBuilder();
        int last = 0;
        int i = 0;
        while ((double)i < textLength) {
            String format;
            double red = (double)this.startColor.getRed() + redDiff * (double)i;
            double green = (double)this.startColor.getGreen() + greenDiff * (double)i;
            double blue = (double)this.startColor.getBlue() + blueDiff * (double)i;
            lineText.append(this.chatColor(red, green, blue));
            if (formatting.containsKey(i)) {
                last = i;
            }
            if ((format = (String)formatting.get(last)) != null) {
                lineText.append((String)formatting.get(last));
            }
            lineText.append(textArray[i]);
            ++i;
        }
        return lineText.toString();
    }

    private ChatColor chatColor(double red, double green, double blue) {
        return ChatColor.of((Color)new Color((int)Math.round(red), (int)Math.round(green), (int)Math.round(blue)));
    }

    private Color parseColor(String attributeName) {
        if (!ServerVersion.current().isNewerThanOrEqualTo(ServerVersion.v1_16)) {
            ((AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class)).log(Level.SEVERE, "The gradient tag is only supported on server version 1.16+", new Object[0]);
            return null;
        }
        String color = (String)this.attributes.getParsedValue(this.player, attributeName);
        if (color == null || color.length() < 8) {
            ((AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class)).log(Level.SEVERE, "{0} color {1} is not a valid color for a gradient tag!", attributeName, color);
            return null;
        }
        Matcher matcher = PatternType.HEX_COLOR.getMatcher(color);
        if (!matcher.matches()) {
            ((AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class)).log(Level.SEVERE, "{0} color {1} is not a valid color for a gradient tag!", attributeName, color);
            return null;
        }
        return Color.decode(color.substring(1));
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }
}

