/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.config.PlayerScoreboardFile;
import me.jasperjh.animatedscoreboard.enums.WorldOption;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTemplate;
import me.jasperjh.animatedscoreboard.objects.ScoreboardOption;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import me.jasperjh.animatedscoreboard.objects.ScoreboardWorld;
import me.jasperjh.animatedscoreboard.objects.trigger.PlayerScoreboardTriggerTemplate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PlayerScoreboardHandler {
    private final AnimatedScoreboard plugin;
    private final Map<UUID, ScoreboardPlayer> players;
    private final Map<String, PlayerScoreboardTemplate> scoreboards;
    private final Map<String, ScoreboardWorld> worlds;
    private final List<PlayerScoreboardTriggerTemplate> triggerBoards;
    private final Map<WorldOption, ScoreboardOption> optionTemplates;
    private BukkitTask task;

    public PlayerScoreboardHandler(AnimatedScoreboard plugin) {
        this.plugin = plugin;
        this.players = Maps.newConcurrentMap();
        this.scoreboards = new TreeMap<String, PlayerScoreboardTemplate>(String.CASE_INSENSITIVE_ORDER);
        this.worlds = new TreeMap<String, ScoreboardWorld>(String.CASE_INSENSITIVE_ORDER);
        this.triggerBoards = Lists.newArrayList();
        this.optionTemplates = Maps.newEnumMap(WorldOption.class);
    }

    public void loadOnlinePlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ScoreboardPlayer scoreboardPlayer = new ScoreboardPlayer(this.plugin, player);
            this.players.put(player.getUniqueId(), scoreboardPlayer);
            scoreboardPlayer.switchScoreboard(player.getWorld());
        }
    }

    public ScoreboardPlayer registerPlayer(Player player) {
        if (!player.isOnline()) {
            return null;
        }
        return this.players.computeIfAbsent(player.getUniqueId(), k -> new ScoreboardPlayer(this.plugin, player));
    }

    public void removePlayer(Player player) {
        ScoreboardPlayer scoreboardPlayer = this.players.remove(player.getUniqueId());
        if (scoreboardPlayer == null) {
            return;
        }
        scoreboardPlayer.removeScoreboardNow();
        this.plugin.getPlayerStorage().setScoreboardEnabled(player.getUniqueId(), scoreboardPlayer.isScoreboardEnabled());
    }

    public void updatePlayer(Player player) {
        ScoreboardPlayer scoreboardPlayer = this.players.get(player.getUniqueId());
        if (scoreboardPlayer != null) {
            scoreboardPlayer.switchScoreboard(player.getWorld());
        } else {
            this.registerPlayer(player);
        }
    }

    private ScoreboardWorld getWorld(String name) {
        if (this.worlds.containsKey(name)) {
            return this.worlds.get(name);
        }
        ScoreboardWorld scoreboardWorld = new ScoreboardWorld(this);
        this.worlds.put(name, scoreboardWorld);
        return scoreboardWorld;
    }

    public ScoreboardOption getOption(WorldOption option) {
        return this.optionTemplates.get((Object)option);
    }

    public PlayerScoreboardTemplate getOrCreateTemplate(String file) {
        if (this.scoreboards.containsKey(file)) {
            return this.scoreboards.get(file);
        }
        String permission = this.plugin.getConfigFile().getString("permissions." + file);
        PlayerScoreboardFile scoreboardFile = new PlayerScoreboardFile(this.plugin, file);
        PlayerScoreboardTemplate template = new PlayerScoreboardTemplate(scoreboardFile, permission);
        this.scoreboards.put(file, template);
        return template;
    }

    public PlayerScoreboardFile getScoreboardConfig(String name) {
        return new PlayerScoreboardFile(this.plugin, name);
    }

    public void addTemplate(WorldOption option, String file) {
        this.getOrCreateTemplate(file);
        this.optionTemplates.computeIfAbsent(option, key -> new ScoreboardOption(this)).addBoard(file);
    }

    public void addTemplate(String world, String file) {
        this.getOrCreateTemplate(file);
        this.getWorld(world).addBoard(file);
    }

    public Map<String, PlayerScoreboardTemplate> getScoreboards() {
        return Collections.unmodifiableMap(this.scoreboards);
    }

    public Collection<String> getScoreboardNames() {
        return Collections.unmodifiableCollection(this.scoreboards.keySet());
    }

    public Map<WorldOption, ScoreboardOption> getOptionsWithBoards() {
        return Collections.unmodifiableMap(this.optionTemplates);
    }

    public Map<String, ScoreboardWorld> getWorlds() {
        return this.worlds;
    }

    public boolean isActiveIn(String board, World world) {
        if (board == null) {
            return false;
        }
        for (Map.Entry<WorldOption, ScoreboardOption> entries : this.optionTemplates.entrySet()) {
            if (!entries.getValue().hasScoreboard(board)) continue;
            return true;
        }
        if (world == null) {
            return false;
        }
        ScoreboardWorld scoreboardWorld = this.worlds.get(world.getName());
        if (scoreboardWorld == null) {
            return false;
        }
        return scoreboardWorld.hasScoreboard(board);
    }

    public PlayerScoreboardTemplate getScoreboardByName(String name) {
        if (name == null) {
            return null;
        }
        return this.scoreboards.get(name);
    }

    public void addTriggerScoreboard(PlayerScoreboardTriggerTemplate template) {
        this.triggerBoards.add(template);
    }

    public void init() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            Iterator<ScoreboardPlayer> players = this.players.values().iterator();
            while (players.hasNext()) {
                ScoreboardPlayer player = players.next();
                try {
                    if (player.tickScoreboards()) continue;
                    players.remove();
                }
                catch (Exception e) {
                    this.plugin.log(Level.SEVERE, "Something went wrong during a scoreboard tick of {0}:", player.getPlayer() == null ? "null" : player.getPlayer().getName());
                    if (player.getPlayer() != null) {
                        player.switchScoreboard(player.getPlayer().getWorld());
                    }
                    e.printStackTrace();
                }
            }
        }, 20L, 1L);
    }

    public void clearScoreboards() {
        if (this.task != null) {
            this.task.cancel();
        }
        for (ScoreboardPlayer player : this.players.values()) {
            player.removeScoreboardNow();
            this.plugin.getPlayerStorage().setScoreboardEnabled(player.getPlayer().getUniqueId(), player.isScoreboardEnabled());
        }
        for (ScoreboardWorld world : this.worlds.values()) {
            world.clearScoreboards();
        }
        this.scoreboards.clear();
        this.worlds.clear();
        this.triggerBoards.clear();
        this.optionTemplates.clear();
    }

    public ScoreboardWorld getScoreboardWorldByName(String name) {
        return this.worlds.get(name);
    }

    public ScoreboardPlayer getPlayer(UUID uniqueId) {
        Player player;
        ScoreboardPlayer scoreboardPlayer = this.players.get(uniqueId);
        if (scoreboardPlayer == null && (player = Bukkit.getPlayer((UUID)uniqueId)) != null) {
            return this.registerPlayer(player);
        }
        return scoreboardPlayer;
    }

    public ScoreboardPlayer getPlayer(Player player) {
        return this.registerPlayer(player);
    }

    public boolean hasScoreboardEnabled(UUID uuid) {
        ScoreboardPlayer player = this.getPlayer(uuid);
        if (player != null) {
            return player.isScoreboardEnabled();
        }
        return false;
    }

    public boolean hasScoreboardEnabled(Player player) {
        ScoreboardPlayer scoreboardPlayer = this.getPlayer(player);
        if (scoreboardPlayer != null) {
            return scoreboardPlayer.isScoreboardEnabled();
        }
        return false;
    }
}

