/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.core;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import me.jasperjh.animatedscoreboard.enums.PatternType;
import me.jasperjh.animatedscoreboard.exceptions.PlaceholderParseException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderHandler {
    private boolean placeholderEnabled;

    public String replacePlaceholdersThrows(Player player, String text) throws PlaceholderParseException {
        if (this.placeholderEnabled) {
            return this.replaceBoth(player, text);
        }
        return text;
    }

    public String replacePlaceholders(Player player, String text) {
        if (this.placeholderEnabled) {
            try {
                return this.replaceBoth(player, text);
            }
            catch (PlaceholderParseException e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public boolean containsPlaceholders(String text) {
        if (this.placeholderEnabled && Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return me.clip.placeholderapi.PlaceholderAPI.containsPlaceholders((String)text);
        }
        return text != null && PatternType.PLACEHOLDER.getMatcher(text).find();
    }

    private String replaceBoth(Player player, String text) throws PlaceholderParseException {
        return this.replaceMVdWPlaceholders(player, this.replacePlaceholderAPI(player, text));
    }

    private String replacePlaceholderAPI(Player player, String text) throws PlaceholderParseException {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            try {
                return me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)player, (String)text);
            }
            catch (Exception | LinkageError e) {
                throw new PlaceholderParseException("PlaceholderAPI", text, player, e);
            }
        }
        return text;
    }

    private String replaceMVdWPlaceholders(Player player, String text) throws PlaceholderParseException {
        if (Bukkit.getPluginManager().isPluginEnabled("MVdWPlaceholderAPI")) {
            try {
                return PlaceholderAPI.replacePlaceholders((OfflinePlayer)player, (String)text);
            }
            catch (Exception | LinkageError e) {
                throw new PlaceholderParseException("MVdWPlaceholderAPI", text, player, e);
            }
        }
        return text;
    }

    public PlaceholderHandler(boolean placeholderEnabled) {
        this.placeholderEnabled = placeholderEnabled;
    }

    public boolean isPlaceholderEnabled() {
        return this.placeholderEnabled;
    }
}

