/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.hooks.PluginHook;
import me.jasperjh.animatedscoreboard.hooks.permission.GroupManagerHook;
import me.jasperjh.animatedscoreboard.hooks.permission.LuckPermsHook;
import me.jasperjh.animatedscoreboard.hooks.permission.zPermissionsHook;
import me.jasperjh.animatedscoreboard.hooks.placeholders.PlaceholderAPIHook;

public class HookManager {
    private final AnimatedScoreboard plugin;
    private final List<PluginHook> enabledHooks;

    public HookManager(AnimatedScoreboard plugin) {
        this.plugin = plugin;
        this.enabledHooks = new ArrayList<PluginHook>();
    }

    public void enable() {
        if (!this.enabledHooks.isEmpty()) {
            return;
        }
        ArrayList<PluginHook> hooks = new ArrayList<PluginHook>();
        hooks.add(new PlaceholderAPIHook(this.plugin));
        hooks.add(new GroupManagerHook(this.plugin));
        hooks.add(new LuckPermsHook(this.plugin));
        hooks.add(new zPermissionsHook(this.plugin));
        for (PluginHook pluginHook : hooks) {
            if (!pluginHook.canEnable()) continue;
            try {
                pluginHook.enable();
                this.enabledHooks.add(pluginHook);
                this.plugin.log(Level.INFO, "Successfully enabled the {0} hook!", pluginHook.getName());
            }
            catch (Exception e) {
                this.plugin.log(Level.INFO, "Failed to hook into {0}. Cause: {1}", pluginHook.getName(), e.getMessage());
            }
        }
    }

    public List<PluginHook> getEnabledHooks() {
        return Collections.unmodifiableList(this.enabledHooks);
    }

    public void reload() {
        for (PluginHook hook : this.enabledHooks) {
            hook.reload();
        }
    }
}

