/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.config;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.config.BasicConfig;
import me.jasperjh.animatedscoreboard.objects.trigger.PlayerScoreboardTriggerTemplate;
import org.bukkit.configuration.file.YamlConfiguration;

public class TriggerConfig
extends BasicConfig {
    public TriggerConfig(AnimatedScoreboard plugin, String name) {
        super(plugin, "triggers", name);
    }

    @Override
    public void loadConfig(YamlConfiguration configuration, boolean newFile) {
    }

    @Override
    public void loadFile(File configFile, boolean newFile) {
        block14: {
            if (!newFile) {
                return;
            }
            try (InputStream in = this.plugin.getResource("trigger.yml");){
                if (in == null) break block14;
                try (FileOutputStream out = new FileOutputStream(configFile);){
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDefaultFile() {
        if (!this.fileName.equalsIgnoreCase("trigger.yml")) {
            return false;
        }
        try (InputStream in = this.plugin.getResource("trigger.yml");){
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in));
            if (!defaultConfig.getString("event", "").equalsIgnoreCase(this.getEvent())) {
                boolean bl = false;
                return bl;
            }
            if (!defaultConfig.getString("trigger-scoreboard", "").equalsIgnoreCase(this.getScoreboardToTrigger().getName())) {
                boolean bl = false;
                return bl;
            }
            if (defaultConfig.getLong("stay-time", 0L) != this.getStayTime()) {
                boolean bl = false;
                return bl;
            }
            if (!defaultConfig.getString("target-player", "").equalsIgnoreCase(this.getPlayerMethod())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getEvent() {
        return this.getString("event");
    }

    public PlayerScoreboardTriggerTemplate getScoreboardToTrigger() {
        String triggerConfigFile = this.getString("trigger-scoreboard");
        return new PlayerScoreboardTriggerTemplate(this.plugin.getScoreboardHandler().getScoreboardConfig(triggerConfigFile));
    }

    public String getCondition() {
        return this.getString("condition");
    }

    public long getStayTime() {
        return this.configuration.getLong("stay-time");
    }

    public String getPlayerMethod() {
        return this.getString("target-player");
    }

    public boolean resetOnTrigger() {
        return this.getBoolean("reset-on-trigger", false);
    }
}

