/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.config;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.config.BasicConfig;
import me.jasperjh.animatedscoreboard.display.attribute.ConfigAttribute;
import me.jasperjh.animatedscoreboard.display.attribute.TagAttributes;
import me.jasperjh.animatedscoreboard.enums.AttributeType;
import me.jasperjh.animatedscoreboard.enums.LineType;
import me.jasperjh.animatedscoreboard.enums.PatternType;
import me.jasperjh.animatedscoreboard.enums.ScoreboardFormat;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardLineTemplate;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTag;
import me.jasperjh.animatedscoreboard.objects.format.FormattedLine;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerScoreboardFile
extends BasicConfig {
    public PlayerScoreboardFile(AnimatedScoreboard plugin, String name) {
        super(plugin, "scoreboards", name);
    }

    @Override
    public void loadConfig(YamlConfiguration configuration, boolean newFile) {
    }

    @Override
    public void loadFile(File configFile, boolean newFile) {
        block14: {
            if (!newFile) {
                return;
            }
            try (InputStream in = this.plugin.getResource("defaultscoreboard.yml");){
                if (in == null) break block14;
                try (FileOutputStream out = new FileOutputStream(configFile);){
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<PlayerScoreboardLineTemplate> loadLines() {
        ScoreboardFormat format = ScoreboardFormat.getFormat(this);
        if (format == null) {
            throw new RuntimeException("Scoreboard file '" + this.fileName + "' has an invalid syntax!");
        }
        return format.parse(this).stream().limit(16L).map(this::build).collect(Collectors.toCollection(ArrayList::new));
    }

    private PlayerScoreboardLineTemplate build(FormattedLine line) {
        ArrayList<PlayerScoreboardTag> tags = new ArrayList<PlayerScoreboardTag>();
        ConfigAttribute attribute = new ConfigAttribute("score", AttributeType.DOUBLE, line.getScore());
        for (String displaytext : line.getText()) {
            tags.add(this.build(displaytext, line.getUpdate()));
        }
        return new PlayerScoreboardLineTemplate(tags, line.getUpdate(), line.isRandom(), attribute);
    }

    private PlayerScoreboardTag build(String text, int update) {
        Matcher matcher = PatternType.TAG.getMatcher(text);
        PlayerScoreboardTag tag = null;
        if (matcher.find()) {
            String tagName = matcher.group(1);
            for (LineType type : LineType.values()) {
                if (type == LineType.DEFAULT || !type.getName().equalsIgnoreCase(tagName)) continue;
                TagAttributes attributes = type.newAttributes();
                Matcher m = PatternType.ATTRIBUTE.getMatcher(matcher.group(2).trim());
                while (m.find()) {
                    String[] attribute = m.group(0).trim().split("=");
                    attributes.applyValue(attributes.getAttribute(attribute[0]), attribute[1]);
                }
                if (type.equals((Object)LineType.UPDATE) && attributes.getValue("stay").equalsIgnoreCase("60")) {
                    attributes.applyValue("stay", "" + update);
                }
                tag = type.newTag(this.plugin, attributes, matcher.group(3));
                break;
            }
        }
        if (tag == null) {
            tag = LineType.DEFAULT.newTag(this.plugin, null, text);
        }
        return tag;
    }
}

