/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class BasicConfig {
    protected final AnimatedScoreboard plugin;
    protected final String directoryName;
    protected final String fileName;
    protected YamlConfiguration configuration;

    public BasicConfig(AnimatedScoreboard plugin, String fileName) {
        this(plugin, null, fileName);
    }

    public BasicConfig(AnimatedScoreboard plugin, String directoryName, String fileName) {
        this.plugin = plugin;
        this.directoryName = directoryName;
        this.fileName = fileName.endsWith(".yml") ? fileName : fileName.concat(".yml");
        this.load();
    }

    public void load() {
        File configFile;
        boolean exists;
        File directory = this.plugin.getDataFolder();
        if (this.directoryName != null && !this.directoryName.isEmpty()) {
            directory = new File(this.plugin.getDataFolder() + File.separator + this.directoryName);
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(exists = (configFile = new File(directory, this.fileName)).exists())) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadFile(configFile, !exists);
        this.configuration = YamlConfiguration.loadConfiguration((File)configFile);
        this.loadConfig(this.configuration, !exists);
    }

    public void saveConfig() {
        File directory = this.plugin.getDataFolder();
        if (this.directoryName != null && !this.directoryName.isEmpty()) {
            directory = new File(this.plugin.getDataFolder() + File.separator + this.directoryName);
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File configFile = new File(directory, this.fileName);
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            this.configuration.save(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFileNameWithoutExtension() {
        int index = this.fileName.lastIndexOf(46);
        if (index == -1) {
            return this.fileName;
        }
        return this.fileName.substring(0, index);
    }

    public void reloadConfig() {
        this.load();
    }

    public abstract void loadFile(File var1, boolean var2);

    public abstract void loadConfig(YamlConfiguration var1, boolean var2);

    public void set(String path, Object value) {
        this.configuration.set(path, value);
        this.saveConfig();
    }

    public boolean contains(String path) {
        return this.configuration.contains(path);
    }

    public boolean isList(String path) {
        return this.configuration.isList(path);
    }

    public int getInt(String path) {
        return this.configuration.getInt(path);
    }

    public int getInt(String path, int defaultValue) {
        return this.configuration.getInt(path, defaultValue);
    }

    public String getString(String path) {
        return this.configuration.getString(path);
    }

    public String getString(String path, String defaultValue) {
        return this.configuration.getString(path, defaultValue);
    }

    public boolean getBoolean(String path) {
        return this.configuration.getBoolean(path);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.configuration.getBoolean(path, defaultValue);
    }

    public Object get(String path) {
        return this.configuration.get(path);
    }

    public Object get(String path, Object defaultValue) {
        return this.configuration.get(path, defaultValue);
    }

    public List<String> getStringList(String path) {
        return this.configuration.getStringList(path);
    }

    public boolean isConfigurationSection(String path) {
        return this.configuration.isConfigurationSection(path);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.configuration.getConfigurationSection(path);
    }

    public ConfigurationSection createSection(String path) {
        return this.configuration.createSection(path);
    }

    public AnimatedScoreboard getPlugin() {
        return this.plugin;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public YamlConfiguration getConfiguration() {
        return this.configuration;
    }
}

