/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.subcommands;

import java.util.Optional;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderData;
import me.jasperjh.animatedscoreboard.commands.data.SubCommandExecutor;
import me.jasperjh.animatedscoreboard.enums.Messages;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ToggleCommand
implements SubCommandExecutor {
    private final AnimatedScoreboard plugin;
    private final SubToggleOnCommand toggleOnSubCommand = new SubToggleOnCommand();
    private final SubToggleOffCommand toggleOffSubCommand = new SubToggleOffCommand();

    @Override
    public void run(CommandSender sender, String label, String[] args, PlaceholderData placeholderData) {
        Optional<Player> optionalTarget = placeholderData.getData("target", Player.class);
        if (optionalTarget.isPresent()) {
            Player target = optionalTarget.get();
            ScoreboardPlayer scoreboardPlayer = this.plugin.getScoreboardHandler().getPlayer(target);
            if (scoreboardPlayer.toggle()) {
                Messages.TOGGLE_ON_OTHER_TARGET.send((CommandSender)target, "%sender%", sender.getName());
                Messages.TOGGLE_ON_OTHER_SENDER.send(sender, "%target%", target.getName());
            } else {
                Messages.TOGGLE_OFF_OTHER_TARGET.send((CommandSender)target, "%sender%", sender.getName());
                Messages.TOGGLE_OFF_OTHER_SENDER.send(sender, "%target%", target.getName());
            }
            return;
        }
        if (!(sender instanceof Player)) {
            Messages.ONLY_PLAYER.send(sender, new String[0]);
            return;
        }
        Player player = (Player)sender;
        ScoreboardPlayer scoreboardPlayer = this.plugin.getScoreboardHandler().getPlayer(player);
        if (scoreboardPlayer.toggle()) {
            Messages.TOGGLE_ON.send((CommandSender)player, new String[0]);
        } else {
            Messages.TOGGLE_OFF.send((CommandSender)player, new String[0]);
        }
    }

    public ToggleCommand(AnimatedScoreboard plugin) {
        this.plugin = plugin;
    }

    public SubToggleOnCommand getToggleOnSubCommand() {
        return this.toggleOnSubCommand;
    }

    public SubToggleOffCommand getToggleOffSubCommand() {
        return this.toggleOffSubCommand;
    }

    private class SubToggleOnCommand
    implements SubCommandExecutor {
        private SubToggleOnCommand() {
        }

        @Override
        public void run(CommandSender sender, String label, String[] args, PlaceholderData placeholderData) {
            Optional<Player> optionalTarget = placeholderData.getData("target", Player.class);
            if (optionalTarget.isPresent()) {
                Player target = optionalTarget.get();
                ScoreboardPlayer scoreboardPlayer = ToggleCommand.this.plugin.getScoreboardHandler().getPlayer(target);
                scoreboardPlayer.enableScoreboard();
                Messages.TOGGLE_ON_OTHER_TARGET.send((CommandSender)target, "%sender%", sender.getName());
                Messages.TOGGLE_ON_OTHER_SENDER.send(sender, "%target%", target.getName());
                return;
            }
            if (!(sender instanceof Player)) {
                Messages.ONLY_PLAYER.send(sender, new String[0]);
                return;
            }
            Player player = (Player)sender;
            ScoreboardPlayer scoreboardPlayer = ToggleCommand.this.plugin.getScoreboardHandler().getPlayer(player);
            scoreboardPlayer.enableScoreboard();
            Messages.TOGGLE_ON.send((CommandSender)player, new String[0]);
        }
    }

    private class SubToggleOffCommand
    implements SubCommandExecutor {
        private SubToggleOffCommand() {
        }

        @Override
        public void run(CommandSender sender, String label, String[] args, PlaceholderData placeholderData) {
            Optional<Player> optionalTarget = placeholderData.getData("target", Player.class);
            if (optionalTarget.isPresent()) {
                Player target = optionalTarget.get();
                ScoreboardPlayer scoreboardPlayer = ToggleCommand.this.plugin.getScoreboardHandler().getPlayer(target);
                scoreboardPlayer.disableScoreboard();
                Messages.TOGGLE_OFF_OTHER_TARGET.send((CommandSender)target, "%sender%", sender.getName());
                Messages.TOGGLE_OFF_OTHER_SENDER.send(sender, "%target%", target.getName());
                return;
            }
            if (!(sender instanceof Player)) {
                Messages.ONLY_PLAYER.send(sender, new String[0]);
                return;
            }
            Player player = (Player)sender;
            ScoreboardPlayer scoreboardPlayer = ToggleCommand.this.plugin.getScoreboardHandler().getPlayer(player);
            scoreboardPlayer.disableScoreboard();
            Messages.TOGGLE_OFF.send((CommandSender)player, new String[0]);
        }
    }
}

