/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.subcommands;

import java.util.Optional;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderData;
import me.jasperjh.animatedscoreboard.commands.data.SubCommandExecutor;
import me.jasperjh.animatedscoreboard.enums.Messages;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTemplate;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SwitchCommand
implements SubCommandExecutor {
    private final AnimatedScoreboard plugin;

    @Override
    public void run(CommandSender sender, String label, String[] args, PlaceholderData placeholderData) {
        Optional<PlayerScoreboardTemplate> optionalScoreboard = placeholderData.getData("scoreboard", PlayerScoreboardTemplate.class);
        if (!optionalScoreboard.isPresent()) {
            Messages.SWITCH_ERROR.send(sender, new String[0]);
            return;
        }
        PlayerScoreboardTemplate template = optionalScoreboard.get();
        Optional<Player> optionalTarget = placeholderData.getData("target", Player.class);
        if (optionalTarget.isPresent()) {
            Player target = optionalTarget.get();
            if (template.hasPermission() && target.hasPermission(template.getPermission()) || !template.hasPermission()) {
                this.switchScoreboardOther(target, sender, template);
            } else {
                Messages.SWITCH_PERMISSION_OTHER.send(sender, "%scoreboard%", template.getName(), "%target%", target.getName());
            }
            return;
        }
        if (!(sender instanceof Player)) {
            Messages.ONLY_PLAYER.send(sender, new String[0]);
            return;
        }
        Player player = (Player)sender;
        if (template.hasPermission() && player.hasPermission(template.getPermission()) || !template.hasPermission()) {
            this.switchScoreboard(player, template);
        } else {
            Messages.SWITCH_PERMISSION.send((CommandSender)player, "%scoreboard%", template.getName());
        }
    }

    private void switchScoreboardOther(Player target, CommandSender sender, PlayerScoreboardTemplate template) {
        if (this.plugin.getScoreboardHandler().isActiveIn(template.getName(), target.getWorld())) {
            ScoreboardPlayer scoreboardPlayer = this.plugin.getScoreboardHandler().getPlayer(target);
            if (scoreboardPlayer.hasScoreboard() && scoreboardPlayer.getScoreboard().getName().equals(template.getName())) {
                Messages.SWITCH_ACTIVE_OTHER.send(sender, "%target%", target.getName(), "%scoreboard%", template.getName());
            } else {
                scoreboardPlayer.switchScoreboard(target.getWorld(), template);
                Messages.SWITCH_SUCCESS_OTHER.send(sender, "%scoreboard%", template.getName(), "%target%", target.getName());
                Messages.SWITCHED_BY_OTHER.send((CommandSender)target, "%scoreboard%", template.getName(), "%sender%", sender.getName());
            }
        } else {
            Messages.SWITCH_WORLD_OTHER.send(sender, "%world%", target.getWorld().getName(), "%target%", target.getName(), "%scoreboard%", template.getName());
        }
    }

    private void switchScoreboard(Player player, PlayerScoreboardTemplate template) {
        if (this.plugin.getScoreboardHandler().isActiveIn(template.getName(), player.getWorld())) {
            ScoreboardPlayer scoreboardPlayer = this.plugin.getScoreboardHandler().getPlayer(player);
            if (scoreboardPlayer.hasScoreboard() && scoreboardPlayer.getScoreboard().getName().equals(template.getName())) {
                Messages.SWITCH_ACTIVE.send((CommandSender)player, new String[0]);
            } else {
                scoreboardPlayer.switchScoreboard(player.getWorld(), template);
                Messages.SWITCH_SUCCESS.send((CommandSender)player, "%scoreboard%", template.getName());
            }
        } else {
            Messages.SWITCH_WORLD.send((CommandSender)player, new String[0]);
        }
    }

    public SwitchCommand(AnimatedScoreboard plugin) {
        this.plugin = plugin;
    }
}

