/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.subcommands;

import java.util.List;
import java.util.Map;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderData;
import me.jasperjh.animatedscoreboard.commands.data.SubCommandExecutor;
import me.jasperjh.animatedscoreboard.enums.WorldOption;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTemplate;
import me.jasperjh.animatedscoreboard.objects.ScoreboardOption;
import me.jasperjh.animatedscoreboard.objects.ScoreboardWorld;
import me.jasperjh.animatedscoreboard.objects.trigger.Trigger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListCommand
implements SubCommandExecutor {
    private final AnimatedScoreboard plugin;

    @Override
    public void run(CommandSender sender, String label, String[] args, PlaceholderData placeholderData) {
        this.plugin.getScoreboardHandler().getOptionsWithBoards().entrySet().forEach(option -> this.send(sender, this.buildOptionMessage((Map.Entry<WorldOption, ScoreboardOption>)option)));
        this.plugin.getScoreboardHandler().getWorlds().keySet().forEach(world -> this.send(sender, this.buildWorldMessage((String)world)));
        if (this.plugin.getTriggerHandler() != null) {
            this.plugin.getTriggerHandler().getTriggers().values().forEach(trigger -> this.send(sender, this.buildTriggerMessage((Trigger)trigger)));
        }
    }

    private void send(CommandSender commandSender, TextComponent textComponent) {
        if (commandSender instanceof Player) {
            ((Player)commandSender).spigot().sendMessage((BaseComponent)textComponent);
        } else {
            commandSender.sendMessage(textComponent.toLegacyText());
        }
    }

    public TextComponent buildWorldMessage(String world) {
        ScoreboardWorld scoreboardWorld = this.plugin.getScoreboardHandler().getScoreboardWorldByName(world);
        TextComponent message = new TextComponent(ChatColor.YELLOW + world + ChatColor.GRAY + ": ");
        this.addScoreboard(scoreboardWorld.getBoards(), message);
        return message;
    }

    public TextComponent buildTriggerMessage(Trigger trigger) {
        String name = trigger.getEventName();
        String[] split = name.split("\\.");
        name = split[split.length - 1];
        TextComponent message = new TextComponent(ChatColor.YELLOW + name + " trigger" + ChatColor.GRAY + ": ");
        TextComponent text = new TextComponent(ChatColor.AQUA + trigger.getBoardToTrigger().getName());
        ComponentBuilder hover = new ComponentBuilder(ChatColor.AQUA + "Unable to switch to trigger scoreboards!");
        text.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hover.create()));
        message.addExtra((BaseComponent)text);
        return message;
    }

    private TextComponent buildOptionMessage(Map.Entry<WorldOption, ScoreboardOption> entry) {
        String name = entry.getKey().getKeyWord().toUpperCase();
        TextComponent message = new TextComponent(ChatColor.YELLOW + name + "" + ChatColor.GRAY + ": ");
        ComponentBuilder hover = new ComponentBuilder(ChatColor.AQUA + "This is a " + ChatColor.DARK_AQUA + entry.getKey().getKeyWord() + ChatColor.AQUA + " scoreboard and will be used when " + ChatColor.DARK_AQUA + entry.getKey().getWhenUsed());
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hover.create()));
        this.addScoreboard(entry.getValue().getBoards(), message);
        return message;
    }

    private void addScoreboard(List<String> scoreboards, TextComponent message) {
        int i = scoreboards.size();
        for (String scoreboardName : scoreboards) {
            TextComponent text = new TextComponent(ChatColor.AQUA + scoreboardName + (i-- > 1 ? ChatColor.GRAY + ", " : ""));
            text.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/asb switch " + scoreboardName));
            ComponentBuilder hover = new ComponentBuilder(ChatColor.AQUA + "Click to switch to " + scoreboardName);
            PlayerScoreboardTemplate scoreboard = this.plugin.getScoreboardHandler().getScoreboardByName(scoreboardName);
            if (scoreboard != null && scoreboard.hasPermission()) {
                hover.append("\n" + ChatColor.AQUA + "Permission: " + ChatColor.DARK_AQUA + scoreboard.getPermission());
            }
            text.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hover.create()));
            message.addExtra((BaseComponent)text);
        }
    }

    public ListCommand(AnimatedScoreboard plugin) {
        this.plugin = plugin;
    }
}

