/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.subcommands;

import java.util.List;
import java.util.stream.Collectors;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderData;
import me.jasperjh.animatedscoreboard.commands.data.SubCommandExecutor;
import me.jasperjh.animatedscoreboard.enums.ConfigSetting;
import me.jasperjh.animatedscoreboard.enums.ServerVersion;
import me.jasperjh.animatedscoreboard.hooks.PluginHook;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboard;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;

public class DebugCommand
implements SubCommandExecutor {
    private final AnimatedScoreboard plugin;

    @Override
    public void run(CommandSender sender, String label, String[] args, PlaceholderData placeholderData) {
        this.send(sender, "&7[&cASB&7] &aDebug information:");
        this.send(sender, "&a - Plugin version: " + this.plugin.getDescription().getVersion());
        this.send(sender, "&a - Server version: " + Bukkit.getServer().getVersion());
        this.send(sender, "&a - Detected server version: " + (Object)((Object)ServerVersion.current()) + " (" + ServerVersion.current().getExactVersion() + ")");
        this.send(sender, "&a - Full support: " + ServerVersion.current().isFullySupported());
        this.send(sender, "&a - Force legacy: " + ConfigSetting.FORCE_LEGACY.getValue());
        this.send(sender, "&a - Implementation: " + this.plugin.getScoreboardImplementation().getClass().getSimpleName());
        this.send(sender, "&a - Enabled hooks: " + this.compileHooks());
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        this.send(sender, "&a - Scoreboard State: " + this.getScoreboardState(player));
    }

    public void send(CommandSender sender, String message) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private String compileHooks() {
        List<PluginHook> enabledHooks = this.plugin.getHookManager().getEnabledHooks();
        if (enabledHooks == null || enabledHooks.isEmpty()) {
            return "&7None";
        }
        return enabledHooks.stream().map(PluginHook::getName).collect(Collectors.joining("&7, &a"));
    }

    private String getScoreboardState(Player player) {
        ScoreboardPlayer scoreboardPlayer = this.plugin.getScoreboardHandler().getPlayer(player);
        if (scoreboardPlayer == null) {
            return "Unknown (invalid scoreboard player state)";
        }
        if (!scoreboardPlayer.isScoreboardEnabled()) {
            return "Disabled (Toggled off)";
        }
        if (scoreboardPlayer.isPaused()) {
            Objective objective = player.getScoreboard().getObjective(DisplaySlot.SIDEBAR);
            String viewing = "unknown scoreboard";
            if (objective != null) {
                viewing = objective.getName() + " / " + objective.getDisplayName();
            }
            return "Paused (occupied by " + viewing + "&a)";
        }
        if (scoreboardPlayer.hasTemporaryScoreboard()) {
            PlayerScoreboard scoreboard = scoreboardPlayer.getScoreboard();
            String viewing = "no scoreboard";
            if (scoreboard != null) {
                viewing = scoreboard.getName();
            }
            return "Temporary ASB (" + viewing + ")";
        }
        if (scoreboardPlayer.hasScoreboard()) {
            PlayerScoreboard scoreboard = scoreboardPlayer.getScoreboard();
            String viewing = "no scoreboard";
            if (scoreboard != null) {
                viewing = scoreboard.getName();
            }
            return "ASB (" + viewing + ")";
        }
        return "Nothing";
    }

    public DebugCommand(AnimatedScoreboard plugin) {
        this.plugin = plugin;
    }
}

