/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.placeholders;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderType;
import me.jasperjh.animatedscoreboard.enums.Messages;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTemplate;
import org.bukkit.util.StringUtil;

public class ScoreboardPlaceholder
extends PlaceholderType<PlayerScoreboardTemplate> {
    private final AnimatedScoreboard plugin;
    private final Predicate<String> validationPredicate;
    private final Function<String, PlayerScoreboardTemplate> converter;
    private final Function<String, List<String>> tabCompletion;

    public ScoreboardPlaceholder(AnimatedScoreboard plugin) {
        this.plugin = plugin;
        this.validationPredicate = input -> !this.getMatchingScoreboards((String)input).isEmpty();
        this.converter = plugin.getScoreboardHandler()::getScoreboardByName;
        this.tabCompletion = this::getMatchingScoreboards;
    }

    @Override
    protected Predicate<String> getValidationPredicate() {
        return this.validationPredicate;
    }

    @Override
    protected Function<String, PlayerScoreboardTemplate> getConverter() {
        return this.converter;
    }

    @Override
    protected Function<String, List<String>> getTabCompletion() {
        return this.tabCompletion;
    }

    @Override
    public Messages getErrorMessage() {
        return Messages.SWITCH_ERROR;
    }

    private List<String> getMatchingScoreboards(String input) {
        ArrayList<String> matchingscoreboards = new ArrayList<String>();
        for (String scoreboard : this.plugin.getScoreboardHandler().getScoreboardNames()) {
            if (!StringUtil.startsWithIgnoreCase((String)scoreboard, (String)input)) continue;
            matchingscoreboards.add(scoreboard);
        }
        Collections.sort(matchingscoreboards, String.CASE_INSENSITIVE_ORDER);
        return matchingscoreboards;
    }
}

