/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.placeholders;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderType;
import me.jasperjh.animatedscoreboard.enums.Messages;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class PlayerPlaceholder
extends PlaceholderType<Player> {
    private final Predicate<String> validationPredicate = input -> !this.getMatchedPlayers((String)input).isEmpty();
    private final Function<String, Player> converter = Bukkit::getPlayer;
    private final Function<String, List<String>> tabCompletion = this::getMatchedPlayers;

    @Override
    protected Predicate<String> getValidationPredicate() {
        return this.validationPredicate;
    }

    @Override
    protected Function<String, Player> getConverter() {
        return this.converter;
    }

    @Override
    protected Function<String, List<String>> getTabCompletion() {
        return this.tabCompletion;
    }

    @Override
    public Messages getErrorMessage() {
        return Messages.INVALID_PLAYER;
    }

    private List<String> getMatchedPlayers(String input) {
        ArrayList<String> matchedPlayers = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            String name = player.getName();
            if (!StringUtil.startsWithIgnoreCase((String)name, (String)input)) continue;
            matchedPlayers.add(name);
        }
        Collections.sort(matchedPlayers, String.CASE_INSENSITIVE_ORDER);
        return matchedPlayers;
    }
}

