/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderData;
import me.jasperjh.animatedscoreboard.commands.data.SubCommandExecutor;
import me.jasperjh.animatedscoreboard.enums.Messages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class SubCommand {
    private static final String[] EMPTY_ARRAY = new String[0];
    private SubCommand parent;
    private final AnimatedScoreboard plugin;
    private final String label;
    private final String permission;
    private SubCommandExecutor executor;
    protected final Map<String, SubCommand> arguments = Maps.newHashMap();

    protected SubCommand(AnimatedScoreboard plugin, String label, String permission, SubCommandExecutor executor) {
        this.plugin = plugin;
        this.label = label;
        this.permission = permission;
        this.executor = executor;
    }

    public boolean routeCommand(CommandSender sender, Command command, String label, String[] args, PlaceholderData placeholderData) {
        if (!this.hasPermission(sender)) {
            Messages.NO_PERMISSION.send(sender, new String[0]);
            return true;
        }
        if (args.length >= 1) {
            String lowerCaseArgument = args[0].toLowerCase();
            SubCommand subCommand = this.arguments.get(lowerCaseArgument);
            if (subCommand != null && subCommand.isValid(lowerCaseArgument)) {
                subCommand.routeCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length), placeholderData);
                return true;
            }
            if (this.arguments.size() >= 1) {
                List placeholders = this.listUnique().stream().filter(sub -> sub.isValid(lowerCaseArgument)).collect(Collectors.toList());
                if (placeholders.size() >= 1) {
                    ((SubCommand)placeholders.get(0)).routeCommand(sender, command, label, args, placeholderData);
                    return true;
                }
                for (SubCommand errorOverriding : this.listUnique()) {
                    if (!errorOverriding.overrideError(lowerCaseArgument)) continue;
                    errorOverriding.routeCommand(sender, command, label, args, placeholderData);
                    return true;
                }
            }
            Messages.INVALID_COMMAND.send(sender, "%command%", this.getLabelTree(label, args).stream().collect(Collectors.joining(" ")));
            return true;
        }
        if (this.executor != null) {
            this.executor.run(sender, label, EMPTY_ARRAY, placeholderData);
            return true;
        }
        Messages.INVALID_COMMAND.send(sender, "%command%", this.getLabelTree(label, args).stream().collect(Collectors.joining(" ")));
        return true;
    }

    public List<String> routeTab(CommandSender sender, Command command, String[] args) {
        if (!this.hasPermission(sender) || args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length >= 1) {
            String lowerCaseArgument = args[0].toLowerCase();
            SubCommand subCommand = this.arguments.get(lowerCaseArgument);
            if (subCommand != null && subCommand.isValid(lowerCaseArgument)) {
                return subCommand.routeTab(sender, command, Arrays.copyOfRange(args, 1, args.length));
            }
            List placeholders = this.listUnique().stream().filter(sub -> sub.isValid(lowerCaseArgument)).collect(Collectors.toList());
            if (placeholders.size() == 1) {
                return ((SubCommand)placeholders.get(0)).routeTab(sender, command, args);
            }
        }
        if (args.length <= 1) {
            String actualArgument = args.length == 0 ? "" : args[0];
            List<String> results = this.compileTabCompletions(sender, actualArgument);
            Collections.sort(results);
            return results;
        }
        return Collections.emptyList();
    }

    public boolean isValid(String argument) {
        return this.label.equalsIgnoreCase(argument);
    }

    public String getLabel() {
        return this.label;
    }

    public List<SubCommand> listUnique() {
        return this.arguments.values().stream().distinct().collect(Collectors.toList());
    }

    public Collection<SubCommand> getArguments() {
        return this.arguments.values();
    }

    public List<String> getLabelTree(String label, String ... arguments) {
        List<SubCommand> commandTree = this.getCommandTree();
        LinkedList<String> labelTree = new LinkedList<String>();
        labelTree.add(label);
        commandTree.remove(0);
        for (SubCommand command : commandTree) {
            labelTree.add(command.getLabel());
        }
        Collections.addAll(labelTree, arguments);
        return labelTree;
    }

    public List<String> compileTabCompletions(CommandSender sender, String argument) {
        ArrayList<String> completions = new ArrayList<String>();
        for (SubCommand subCommand : this.listUnique()) {
            if (!subCommand.hasPermission(sender)) continue;
            subCommand.addTabCompletion(completions, argument);
        }
        return completions;
    }

    public void addTabCompletion(List<String> tabCompletion, String argument) {
        if (StringUtil.startsWithIgnoreCase((String)this.label, (String)argument)) {
            tabCompletion.add(this.label);
        }
    }

    public List<SubCommand> getCommandTree() {
        if (this.parent == null) {
            LinkedList commands = Lists.newLinkedList();
            commands.add(this);
            return commands;
        }
        List<SubCommand> commands = this.parent.getCommandTree();
        commands.add(this);
        return commands;
    }

    protected boolean hasPermission(CommandSender sender) {
        if (this.permission == null || this.permission.isEmpty()) {
            return true;
        }
        return sender.hasPermission(this.permission);
    }

    protected boolean overrideError(String argument) {
        if (argument == null) {
            // empty if block
        }
        return false;
    }

    public SubCommand getParent() {
        return this.parent;
    }

    public AnimatedScoreboard getPlugin() {
        return this.plugin;
    }

    public String getPermission() {
        return this.permission;
    }

    public SubCommandExecutor getExecutor() {
        return this.executor;
    }

    public void setParent(SubCommand parent) {
        this.parent = parent;
    }

    public void setExecutor(SubCommandExecutor executor) {
        this.executor = executor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubCommand)) {
            return false;
        }
        SubCommand other = (SubCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SubCommand this$parent = this.getParent();
        SubCommand other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        AnimatedScoreboard this$plugin = this.getPlugin();
        AnimatedScoreboard other$plugin = other.getPlugin();
        if (this$plugin == null ? other$plugin != null : !((Object)((Object)this$plugin)).equals((Object)other$plugin)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$permission = this.getPermission();
        String other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) {
            return false;
        }
        SubCommandExecutor this$executor = this.getExecutor();
        SubCommandExecutor other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        Collection<SubCommand> this$arguments = this.getArguments();
        Collection<SubCommand> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SubCommand $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        AnimatedScoreboard $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : ((Object)((Object)$plugin)).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
        SubCommandExecutor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        Collection<SubCommand> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public String toString() {
        return "SubCommand(plugin=" + (Object)((Object)this.getPlugin()) + ", label=" + this.getLabel() + ", permission=" + this.getPermission() + ", executor=" + this.getExecutor() + ")";
    }
}

