/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderData;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderType;
import me.jasperjh.animatedscoreboard.commands.data.SubCommand;
import me.jasperjh.animatedscoreboard.commands.data.SubCommandExecutor;
import me.jasperjh.animatedscoreboard.enums.Messages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class PlaceholderSubCommand
extends SubCommand {
    private final String key;
    private final PlaceholderType<?> type;

    protected PlaceholderSubCommand(AnimatedScoreboard plugin, String label, String permission, SubCommandExecutor executor, String key, PlaceholderType<?> type) {
        super(plugin, label, permission, executor);
        this.key = key;
        this.type = type;
    }

    @Override
    public boolean routeCommand(CommandSender sender, Command command, String label, String[] args, PlaceholderData placeholderData) {
        if (!this.hasPermission(sender)) {
            Messages.NO_PERMISSION.send(sender, new String[0]);
            return true;
        }
        if (!this.type.isValid(args[0])) {
            this.type.sendErrorMessage(sender, "%key%", this.key, "%value%", args[0]);
            return true;
        }
        Object converted = this.type.convert(args[0]);
        if (converted == null) {
            this.type.sendErrorMessage(sender, "%key%", this.key, "%value%", args[0]);
            return true;
        }
        placeholderData.addData(this.key, converted);
        return super.routeCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length), placeholderData);
    }

    @Override
    public List<String> routeTab(CommandSender sender, Command command, String[] args) {
        if (!this.hasPermission(sender)) {
            Messages.NO_PERMISSION.send(sender, new String[0]);
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return this.type.tabComplete(args[0]);
        }
        return super.routeTab(sender, command, Arrays.copyOfRange(args, 1, args.length));
    }

    @Override
    public void addTabCompletion(List<String> tabCompletion, String argument) {
        tabCompletion.addAll(this.type.tabComplete(argument));
    }

    @Override
    public boolean isValid(String argument) {
        return !StringUtil.startsWithIgnoreCase((String)this.key, (String)argument) && this.type.isValid(argument);
    }

    @Override
    protected boolean overrideError(String argument) {
        return argument != null;
    }
}

