/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands.data;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.MasterCommand;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderCommandBuilder;
import me.jasperjh.animatedscoreboard.commands.data.PlaceholderType;
import me.jasperjh.animatedscoreboard.commands.data.SubCommand;
import me.jasperjh.animatedscoreboard.commands.data.SubCommandExecutor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;

public class CommandBuilder {
    protected final CommandBuilder parent;
    protected final String command;
    protected String permission;
    protected SubCommandExecutor executor;
    protected Map<String, CommandBuilder> subCommands = Maps.newHashMap();
    protected SubCommand finalProduct = null;

    public CommandBuilder parent() {
        return this.parent;
    }

    public CommandBuilder parent(String parentName) {
        for (Map.Entry<String, CommandBuilder> entry : this.subCommands.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(parentName)) continue;
            return entry.getValue();
        }
        if (this.parent != null) {
            return this.parent.parent(parentName);
        }
        return null;
    }

    public CommandBuilder topParent() {
        if (this.parent != null) {
            return this.parent.topParent();
        }
        return this;
    }

    public CommandBuilder permission(String permission) {
        this.permission = permission;
        return this;
    }

    public CommandBuilder executor(SubCommandExecutor executor) {
        this.executor = executor;
        return this;
    }

    public CommandBuilder argument(String label) {
        return this.subCommands.computeIfAbsent(label.toLowerCase(), command -> new CommandBuilder(this, label));
    }

    public CommandBuilder arguments(String ... arguments) {
        Arrays.stream(arguments).forEach(argument -> this.subCommands.put(argument.toLowerCase(), new CommandBuilder(this, (String)argument)));
        return this;
    }

    public PlaceholderCommandBuilder placeholder(String label, String key, PlaceholderType<?> placeholder) {
        if (this.subCommands.containsKey(key)) {
            CommandBuilder commandBuilder = this.subCommands.get(key);
            return (PlaceholderCommandBuilder)commandBuilder;
        }
        PlaceholderCommandBuilder commandBuilder = new PlaceholderCommandBuilder(this, label, key, placeholder);
        this.subCommands.put(key, commandBuilder);
        return commandBuilder;
    }

    protected SubCommand create(AnimatedScoreboard plugin, boolean register) {
        if (this.finalProduct == null) {
            SubCommand command = new SubCommand(plugin, this.command, this.permission, this.executor);
            this.subCommands.forEach((subCommand, builder) -> {
                SubCommand sub = builder.create(plugin, false);
                sub.setParent(command);
                command.arguments.put((String)subCommand, sub);
            });
            if (register) {
                this.register(command);
            }
            this.finalProduct = command;
            return this.finalProduct;
        }
        return this.finalProduct;
    }

    protected void register(SubCommand subCommand) {
        String commandName = this.command.toLowerCase();
        PluginCommand pluginCommand = Bukkit.getServer().getPluginCommand(commandName);
        MasterCommand masterCommand = new MasterCommand(subCommand);
        pluginCommand.setExecutor((CommandExecutor)masterCommand);
        pluginCommand.setTabCompleter((TabCompleter)masterCommand);
    }

    public SubCommand build(AnimatedScoreboard plugin, boolean register) {
        if (this.parent != null) {
            return this.parent.build(plugin, register);
        }
        return this.create(plugin, register);
    }

    public static CommandBuilder builder(String command) {
        return new CommandBuilder(null, command.toLowerCase());
    }

    protected CommandBuilder(CommandBuilder parent, String command) {
        this.parent = parent;
        this.command = command;
    }

    public CommandBuilder getParent() {
        return this.parent;
    }

    public String getCommand() {
        return this.command;
    }

    public String getPermission() {
        return this.permission;
    }

    public SubCommandExecutor getExecutor() {
        return this.executor;
    }

    public Map<String, CommandBuilder> getSubCommands() {
        return this.subCommands;
    }

    public SubCommand getFinalProduct() {
        return this.finalProduct;
    }
}

