/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard.commands;

import me.jasperjh.animatedscoreboard.AnimatedScoreboard;
import me.jasperjh.animatedscoreboard.commands.data.CommandBuilder;
import me.jasperjh.animatedscoreboard.commands.placeholders.PlayerPlaceholder;
import me.jasperjh.animatedscoreboard.commands.placeholders.ScoreboardPlaceholder;
import me.jasperjh.animatedscoreboard.commands.subcommands.DebugCommand;
import me.jasperjh.animatedscoreboard.commands.subcommands.HelpCommand;
import me.jasperjh.animatedscoreboard.commands.subcommands.InfoCommand;
import me.jasperjh.animatedscoreboard.commands.subcommands.ListCommand;
import me.jasperjh.animatedscoreboard.commands.subcommands.ReloadCommand;
import me.jasperjh.animatedscoreboard.commands.subcommands.SwitchCommand;
import me.jasperjh.animatedscoreboard.commands.subcommands.ToggleCommand;

public class AnimatedScoreboardCommand {
    private final AnimatedScoreboard plugin;

    public void build() {
        CommandBuilder commandBuilder = CommandBuilder.builder("animatedscoreboard");
        PlayerPlaceholder playerPlaceholder = new PlayerPlaceholder();
        ScoreboardPlaceholder scoreboardPlaceholder = new ScoreboardPlaceholder(this.plugin);
        commandBuilder.argument("help").permission("animatedscoreboard.help").executor(new HelpCommand());
        commandBuilder.argument("info").permission("animatedscoreboard.info").executor(new InfoCommand(this.plugin));
        commandBuilder.argument("reload").permission("animatedscoreboard.admin").executor(new ReloadCommand(this.plugin));
        CommandBuilder toggle = commandBuilder.argument("toggle").permission("animatedscoreboard.toggle");
        ToggleCommand toggleCommand = new ToggleCommand(this.plugin);
        toggle.executor(toggleCommand).placeholder("<player>", "target", playerPlaceholder).executor(toggleCommand).permission("animatedscoreboard.toggle.other");
        toggle.argument("on").executor(toggleCommand.getToggleOnSubCommand()).placeholder("<player>", "target", playerPlaceholder).executor(toggleCommand.getToggleOnSubCommand()).permission("animatedscoreboard.toggle.other");
        toggle.argument("off").executor(toggleCommand.getToggleOffSubCommand()).placeholder("<player>", "target", playerPlaceholder).executor(toggleCommand.getToggleOffSubCommand()).permission("animatedscoreboard.toggle.other");
        CommandBuilder switchBuilder = commandBuilder.argument("switch").permission("animatedscoreboard.switch");
        SwitchCommand switchCommand = new SwitchCommand(this.plugin);
        switchBuilder.placeholder("<scoreboard>", "scoreboard", scoreboardPlaceholder).executor(switchCommand).placeholder("<player>", "target", playerPlaceholder).permission("animatedscoreboard.switch.other").executor(switchCommand);
        commandBuilder.argument("list").permission("animatedscoreboard.list").executor(new ListCommand(this.plugin));
        commandBuilder.argument("debug").permission("animatedscoreboard.admin").executor(new DebugCommand(this.plugin));
        commandBuilder.build(this.plugin, true);
    }

    public AnimatedScoreboardCommand(AnimatedScoreboard plugin) {
        this.plugin = plugin;
    }
}

