/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.UUID;
import me.jasperjh.animatedscoreboard.core.PlayerScoreboardHandler;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboard;
import me.jasperjh.animatedscoreboard.objects.ScoreboardPlayer;
import org.bukkit.plugin.java.JavaPlugin;

public class AnimatedScoreboardAPI {
    private final PlayerScoreboardHandler scoreboardHandler;
    private final JavaPlugin plugin;

    protected AnimatedScoreboardAPI(PlayerScoreboardHandler scoreboardHandler, JavaPlugin plugin) {
        this.scoreboardHandler = scoreboardHandler;
        this.plugin = plugin;
    }

    public Optional<ScoreboardPlayer> getScoreboardPlayer(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)(this.plugin.getName() + " tried to load a ScoreboardPlayer instance without providing a valid uuid!"));
        return Optional.fromNullable((Object)this.scoreboardHandler.getPlayer(uuid));
    }

    public Optional<PlayerScoreboard> getPlayerScoreboard(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)(this.plugin.getName() + " tried to load a player's scoreboard without providing a valid uuid!"));
        Optional<ScoreboardPlayer> player = this.getScoreboardPlayer(uuid);
        return player.isPresent() ? this.getPlayerScoreboard((ScoreboardPlayer)player.get()) : Optional.absent();
    }

    public Optional<PlayerScoreboard> getPlayerScoreboard(ScoreboardPlayer player) {
        Preconditions.checkNotNull((Object)player, (Object)(this.plugin.getName() + " tried to load a player's scoreboard without providing a valid ScoreboardPlayer instance!"));
        return Optional.fromNullable((Object)player.getScoreboard());
    }
}

