/*
 * Decompiled with CFR 0.152.
 */
package me.jasperjh.animatedscoreboard;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.jasperjh.animatedscoreboard.AnimatedScoreboardAPI;
import me.jasperjh.animatedscoreboard.commands.AnimatedScoreboardCommand;
import me.jasperjh.animatedscoreboard.config.PluginConfig;
import me.jasperjh.animatedscoreboard.config.TriggerConfig;
import me.jasperjh.animatedscoreboard.core.HookManager;
import me.jasperjh.animatedscoreboard.core.PlaceholderHandler;
import me.jasperjh.animatedscoreboard.core.PlayerScoreboardHandler;
import me.jasperjh.animatedscoreboard.enums.ConfigSetting;
import me.jasperjh.animatedscoreboard.enums.Messages;
import me.jasperjh.animatedscoreboard.enums.ServerVersion;
import me.jasperjh.animatedscoreboard.enums.StorageType;
import me.jasperjh.animatedscoreboard.listeners.ScoreboardListener;
import me.jasperjh.animatedscoreboard.listeners.TriggerListener;
import me.jasperjh.animatedscoreboard.listeners.UpdateListener;
import me.jasperjh.animatedscoreboard.objects.PlayerScoreboardTemplateBuilder;
import me.jasperjh.animatedscoreboard.objects.ScoreboardImplementation;
import me.jasperjh.animatedscoreboard.objects.impl.BukkitImplementation;
import me.jasperjh.animatedscoreboard.objects.impl.PacketImplementation;
import me.jasperjh.animatedscoreboard.objects.trigger.PlayerScoreboardTriggerTemplate;
import me.jasperjh.animatedscoreboard.objects.trigger.PlayerTriggerHandler;
import me.jasperjh.animatedscoreboard.shaded.bstats.bukkit.Metrics;
import me.jasperjh.animatedscoreboard.shaded.bstats.charts.SimplePie;
import me.jasperjh.animatedscoreboard.storage.PlayerStorage;
import me.jasperjh.animatedscoreboard.update.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class AnimatedScoreboard
extends JavaPlugin {
    private static AnimatedScoreboard instance;
    private PluginConfig configFile;
    private PluginConfig messagesFile;
    private PlayerStorage playerStorage;
    private PlayerScoreboardHandler scoreboardHandler;
    private AnimatedScoreboardCommand animatedScoreboardCommand;
    private PlayerTriggerHandler triggerHandler;
    private PlaceholderHandler placeholderHandler;
    private ScoreboardImplementation scoreboardImplementation;
    private HookManager hookManager;
    private boolean debugMode;
    private UpdateChecker updateChecker;
    private boolean disabling;
    private static Map<JavaPlugin, AnimatedScoreboardAPI> plugins;

    public void onEnable() {
        instance = this;
        this.disabling = false;
        this.configFile = new PluginConfig(this, "config");
        this.messagesFile = new PluginConfig(this, "messages");
        Messages.reloadMessages();
        this.debugMode = ConfigSetting.DEBUG_MODE.getValue();
        this.log(Level.INFO, "Plugin loaded in debug mode, check the console for any errors/messages!", new Object[0]);
        ServerVersion serverVersion = ServerVersion.current();
        this.log(Level.INFO, "Detected server version: {0}", serverVersion.name());
        if (!serverVersion.isLegacy() && ConfigSetting.FORCE_LEGACY.getValue()) {
            this.log(Level.INFO, "You are running the plugin in force-legacy mode meaning that you won't be able to use lines which are longer than 32 characters including all color codes.", new Object[0]);
        }
        try {
            if (!serverVersion.isFullySupported()) {
                this.log(Level.SEVERE, "This version of minecraft isn't confirmed working yet and thus the plugin might not work as expected. ASB will try to enable with the improved scoreboard implementation but might fall back to the old Bukkit implementation. You will not get any support when using AnimatedScoreboard on this server!", new Object[0]);
            } else {
                this.log(Level.INFO, "You are running on a supported version, starting up the Packet implementation!", new Object[0]);
            }
            this.scoreboardImplementation = serverVersion == ServerVersion.v1_7 ? new BukkitImplementation() : new PacketImplementation();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            this.log(Level.SEVERE, "Something went wrong while trying to load the Packet implementation so ASB is switching back to the old Bukkit implementation which is incompatible with other scoreboard plugins!", new Object[0]);
            if (this.debugMode) {
                e.printStackTrace();
            }
            this.scoreboardImplementation = new BukkitImplementation();
        }
        if (!this.setupStorage()) {
            this.log(Level.SEVERE, "Couldn't successfully set up the storage type requested! Please check the console for errors and fix the config.yml accordingly!", new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        boolean placeholderapi = ConfigSetting.PLACEHOLDERS.getValue();
        if (placeholderapi) {
            this.log(Level.INFO, "Trying to start with placeholders enabled!", new Object[0]);
        }
        this.placeholderHandler = new PlaceholderHandler(placeholderapi);
        this.scoreboardHandler = new PlayerScoreboardHandler(this);
        this.animatedScoreboardCommand = new AnimatedScoreboardCommand(this);
        this.animatedScoreboardCommand.build();
        this.scoreboardHandler.loadOnlinePlayers();
        this.loadScoreboards();
        this.updateChecker = new UpdateChecker(this);
        if (ConfigSetting.CHECK_UPDATES.getValue()) {
            this.updateChecker.init();
        }
        boolean triggersEnabled = ConfigSetting.TRIGGERS.getValue();
        this.triggerHandler = new PlayerTriggerHandler(this.scoreboardHandler, this, triggersEnabled);
        if (triggersEnabled) {
            this.loadTriggers();
        }
        this.hookManager = new HookManager(this);
        this.hookManager.enable();
        Metrics metrics = new Metrics(this, 1786);
        metrics.addCustomChart(new SimplePie("using_placeholderapi", () -> this.placeholderHandler.isPlaceholderEnabled() ? "yes" : "no"));
        metrics.addCustomChart(new SimplePie("using_event_triggers", () -> triggersEnabled ? "yes" : "no"));
        this.registerListeners();
    }

    public void onDisable() {
        this.disabling = true;
        if (ConfigSetting.TRIGGERS.getValue() && this.triggerHandler != null) {
            this.triggerHandler.unlisten();
        }
        this.scoreboardHandler.clearScoreboards();
        this.playerStorage.close();
    }

    public boolean setupStorage() {
        String storageName = this.getConfigFile().getString("player-storage", "SQLITE");
        StorageType storageType = StorageType.getStorage(storageName);
        if (storageType == null) {
            String support = Stream.of(StorageType.values()).map(Enum::name).collect(Collectors.joining(", "));
            this.log(Level.SEVERE, "Can't find storage type named {0}! We currently only support {1}!", storageName, support);
            return false;
        }
        this.playerStorage = storageType.getPlayerStorage();
        if (!this.playerStorage.isValid(this) || !this.playerStorage.setup(this)) {
            return false;
        }
        for (StorageType type : StorageType.values()) {
            PlayerStorage typeStorage;
            if (type == storageType || !(typeStorage = type.getPlayerStorage()).isValid(this) || !typeStorage.exists(this)) continue;
            this.playerStorage.importAll(typeStorage.clearAll(this));
        }
        return true;
    }

    public void loadScoreboards() {
        this.configFile.reloadConfig();
        if (!this.configFile.contains("worlds")) {
            this.log(Level.SEVERE, "Cannot find a worlds section in your config.yml, please add that section yourself as shown on the ASB overview page on SpigotMC or delete that file and restart the server!", new Object[0]);
            return;
        }
        if (!this.configFile.contains("permissions")) {
            this.log(Level.SEVERE, "Cannot find a permissions section in your config.yml, please add that section yourself as shown on the ASB overview page on SpigotMC or delete that file and restart the server!", new Object[0]);
            return;
        }
        this.scoreboardHandler.clearScoreboards();
        for (String key : this.configFile.getConfigurationSection("worlds").getKeys(false)) {
            new PlayerScoreboardTemplateBuilder(key, this).build();
        }
        this.scoreboardHandler.init();
    }

    public void loadTriggers() {
        if (this.triggerHandler == null || !this.triggerHandler.isEnabled()) {
            return;
        }
        this.triggerHandler.clear();
        TriggerConfig defaultTrigger = new TriggerConfig(this, "trigger");
        this.log(Level.INFO, "Refreshed the standard trigger file {0}!", defaultTrigger.getFileName());
        File directory = new File(this.getDataFolder() + "/triggers");
        if (!directory.exists()) {
            return;
        }
        for (File files : directory.listFiles()) {
            TriggerConfig triggerConfig = new TriggerConfig(this, files.getName().replaceAll(".yml", ""));
            if (triggerConfig.isDefaultFile()) {
                this.log(Level.WARNING, "Ignoring trigger.yml since it is the default file!", new Object[0]);
                continue;
            }
            String eventName = triggerConfig.getEvent();
            PlayerScoreboardTriggerTemplate boardToTrigger = triggerConfig.getScoreboardToTrigger();
            String condition = triggerConfig.getCondition();
            long stayTime = triggerConfig.getStayTime();
            String targetPlayer = triggerConfig.getPlayerMethod();
            boolean resetOnTrigger = triggerConfig.resetOnTrigger();
            this.triggerHandler.addTrigger(eventName, boardToTrigger, condition, stayTime, targetPlayer, resetOnTrigger);
        }
        this.triggerHandler.listen();
    }

    public void log(Level level, String message, Object ... params) {
        if (!this.debugMode && !level.equals(Level.SEVERE)) {
            return;
        }
        this.getLogger().log(level, message, params);
    }

    public static AnimatedScoreboardAPI loadAPI(JavaPlugin plugin) {
        if (plugins.containsKey(plugin)) {
            return plugins.get(plugin);
        }
        AnimatedScoreboard scoreboardPlugin = (AnimatedScoreboard)JavaPlugin.getPlugin(AnimatedScoreboard.class);
        AnimatedScoreboardAPI api = new AnimatedScoreboardAPI(scoreboardPlugin.scoreboardHandler, plugin);
        plugins.put(plugin, api);
        return api;
    }

    private void registerListeners() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new ScoreboardListener(this.scoreboardHandler), (Plugin)this);
        pluginManager.registerEvents((Listener)new TriggerListener(this.triggerHandler), (Plugin)this);
        pluginManager.registerEvents((Listener)new UpdateListener(this.updateChecker), (Plugin)this);
    }

    public PluginConfig getConfigFile() {
        return this.configFile;
    }

    public PluginConfig getMessagesFile() {
        return this.messagesFile;
    }

    public PlayerStorage getPlayerStorage() {
        return this.playerStorage;
    }

    public PlayerScoreboardHandler getScoreboardHandler() {
        return this.scoreboardHandler;
    }

    public AnimatedScoreboardCommand getAnimatedScoreboardCommand() {
        return this.animatedScoreboardCommand;
    }

    public PlayerTriggerHandler getTriggerHandler() {
        return this.triggerHandler;
    }

    public PlaceholderHandler getPlaceholderHandler() {
        return this.placeholderHandler;
    }

    public ScoreboardImplementation getScoreboardImplementation() {
        return this.scoreboardImplementation;
    }

    public HookManager getHookManager() {
        return this.hookManager;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public boolean isDisabling() {
        return this.disabling;
    }

    public static AnimatedScoreboard getInstance() {
        return instance;
    }

    static {
        plugins = Maps.newHashMap();
    }
}

