/*
 * Decompiled with CFR 0.152.
 */
package me.moomoo.anarchyexploitfixes;

import java.awt.Point;
import java.time.Instant;
import java.util.HashSet;
import me.moomoo.anarchyexploitfixes.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Container;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Main
extends JavaPlugin
implements Listener {
    FileConfiguration config = this.getConfig();
    public HashSet<String> playersinnewchunks = new HashSet();
    long lastGathered;
    private static final String HTTP_REGEX_CHECK = "(https?://(?:www\\.|(?!www))[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\\.[^\\s]{2,}|www\\.[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\\.[^\\s]{2,}|https?://(?:www\\.|(?!www))[a-zA-Z0-9]+\\.[^\\s]{2,}|www\\.[a-zA-Z0-9]+\\.[^\\s]{2,})";
    private static final String REGEX_CHECK = "[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z()]{1,6}\\b([-a-zA-Z()@:%_+.~#?&//=]*)";

    public void onEnable() {
        this.saveDefaultConfig();
        System.out.println("[ENABLED] AnarchyExploitFixes - Made by moomoo");
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        int pluginId = 8700;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
    }

    public void onDisable() {
        System.out.println("[DISABLED] AnarchyExploitFixes - Made by moomoo");
    }

    @EventHandler
    public void onElytra(EntityToggleGlideEvent evt) {
        if (this.getConfig().getBoolean("DisableAllElytras")) {
            evt.setCancelled(true);
            evt.getEntity().sendMessage("Elytras currently disabled due to LAG exploit.");
        }
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent evt) {
        String entity = evt.getEntity().toString();
        if (this.getConfig().getBoolean("DisableWithers") && entity.equals("CraftWitherSkull")) {
            evt.setCancelled(true);
        }
    }

    @EventHandler
    private void onPlayerBucketEvent(PlayerBucketEmptyEvent evt) {
        if (this.getConfig().getBoolean("PreventDestroyingEndPortals")) {
            String playerName = evt.getPlayer().getName();
            String type = evt.getBlockClicked().getType().toString();
            String face = evt.getBlockFace().toString();
            String world = evt.getBlockClicked().getWorld().getName();
            if (this.getConfig().getBoolean("DEBUG")) {
                System.out.println("PlayerBucketEmptyEvent " + face + " " + type);
            }
            if (type == "BEDROCK" && world.equalsIgnoreCase("world_the_end") && (face == "NORTH" || face == "EAST" || face == "SOUTH" || face == "WEST")) {
                evt.setCancelled(true);
                System.out.println("Prevented " + playerName + " from destroying a portal!");
            }
            if (type == "ENDER_PORTAL_FRAME" && (face == "NORTH" || face == "EAST" || face == "SOUTH" || face == "WEST")) {
                evt.setCancelled(true);
                System.out.println("Prevented " + playerName + " from destroying a portal!");
            }
            if (!(face != "UP" && face != "DOWN" || evt.getPlayer().getWorld().getBlockAt(evt.getBlockClicked().getX(), evt.getBlockClicked().getY() - 1, evt.getBlockClicked().getZ()).getType().toString() != "ENDER_PORTAL" && evt.getPlayer().getWorld().getBlockAt(evt.getBlockClicked().getX(), evt.getBlockClicked().getY() + 1, evt.getBlockClicked().getZ()).getType().toString() != "ENDER_PORTAL")) {
                evt.setCancelled(true);
                System.out.println("Prevented " + playerName + " from destroying a portal!");
            }
        }
    }

    @EventHandler
    private void onEntityPortalEvent(EntityPortalEvent evt) {
        if (this.getConfig().getBoolean("PreventDonkeysFromGoingThroughPortals")) {
            Entity entity = evt.getEntity();
            if (this.getConfig().getBoolean("DEBUG")) {
                System.out.println("EntityPortalEvent  " + entity);
            }
            if (entity instanceof ChestedHorse && ((ChestedHorse)entity).isCarryingChest()) {
                evt.setCancelled(true);
                if (!this.getConfig().getBoolean("NoConsoleOutput")) {
                    System.out.println("Prevented a " + entity.toString() + " from going through portal");
                }
            }
        }
    }

    @EventHandler
    private void onPlayerInteractEvent(PlayerInteractEvent evt) {
        if (this.getConfig().getBoolean("RemoveIllegalBlocksOnInteract") && evt.getClickedBlock() != null && evt.getClickedBlock().getState() instanceof Container) {
            if (this.getConfig().getBoolean("DEBUG")) {
                System.out.println("PlayerInteractEvent " + evt.getClickedBlock().getType().toString());
            }
            this.getConfig().getList("BANNED_BLOCKS").forEach(b -> ((Container)evt.getClickedBlock().getState()).getInventory().remove(Material.getMaterial((String)((String)b))));
        }
    }

    @EventHandler
    private void onPlayerJoinEvent(PlayerJoinEvent evt) {
        if (this.getConfig().getBoolean("RemoveIllegalBlocksOnJoin")) {
            this.getConfig().getList("BANNED_BLOCKS").forEach(b -> {
                if (this.getConfig().getBoolean("DEBUG")) {
                    System.out.println("PlayerJoinEvent");
                }
                evt.getPlayer().getInventory().remove(Material.getMaterial((String)((String)b)));
            });
        }
        if (this.getConfig().getBoolean("GrayJoinLeaveMessages")) {
            evt.setJoinMessage("\u00a77" + evt.getPlayer().getName() + " joined the game.");
        }
    }

    @EventHandler
    private void onPlayerLeave(PlayerQuitEvent evt) {
        if (this.getConfig().getBoolean("GrayJoinLeaveMessages")) {
            evt.setQuitMessage("\u00a77" + evt.getPlayer().getName() + " left the game.");
        }
    }

    @EventHandler
    private void onInventoryOpenEvent(InventoryOpenEvent evt) {
        if (this.getConfig().getBoolean("RemoveIllegalBlocksOnInventoryOpen")) {
            this.getConfig().getList("BANNED_BLOCKS").forEach(b -> {
                if (this.getConfig().getBoolean("DEBUG")) {
                    System.out.println("InventoryOpenEvent");
                }
                evt.getPlayer().getInventory().remove(Material.getMaterial((String)((String)b)));
            });
        }
    }

    @EventHandler
    private void onBlockDropItemEvent(PlayerDropItemEvent evt) {
        if (this.getConfig().getBoolean("DEBUG")) {
            System.out.println("\u00a76DEBUG: " + evt.getItemDrop().getItemStack().getType().toString());
        }
        if (this.getConfig().getBoolean("RemoveIllegalBlocksOnDrop")) {
            if (this.getConfig().getBoolean("DEBUG")) {
                System.out.println("PlayerDropItemEvent");
            }
            String item = evt.getItemDrop().getItemStack().getType().toString();
            if (this.getConfig().getList("BANNED_BLOCKS").contains(item)) {
                evt.getItemDrop().getItemStack().setType(Material.getMaterial((String)this.getConfig().getString("Replacement_Item")));
                evt.getPlayer().getInventory().remove(Material.BEDROCK);
                evt.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void PlayerMove(PlayerMoveEvent evt) {
        if (evt.getPlayer().isGliding()) {
            Location from = evt.getFrom();
            Location to = evt.getTo();
            double distX = to.getX() - from.getX();
            double distZ = to.getZ() - from.getZ();
            double finalValue = Math.hypot(distX, distZ);
            if (this.playersinnewchunks.contains(evt.getPlayer().getName())) {
                if (finalValue > this.getConfig().getDouble("ElytraNewChunkSpeed")) {
                    evt.setCancelled(true);
                    evt.getPlayer().sendMessage(ChatColor.GRAY + "Turn down your elytra settings, speed is restricted in new chunks.");
                }
            } else if (finalValue > this.getConfig().getDouble("ElytraOldChunkSpeed")) {
                evt.setCancelled(true);
                evt.getPlayer().sendMessage(ChatColor.GRAY + "Turn down your elytra settings, you are going WAY too fast.");
            }
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent evt) {
        if (evt.isNewChunk()) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                Point p2;
                Point p1 = new Point(evt.getChunk().getX(), evt.getChunk().getZ());
                if (!(p1.distance(p2 = new Point(p.getLocation().getChunk().getX(), p.getLocation().getChunk().getZ())) < 25.0)) continue;
                this.playersinnewchunks.add(p.getName());
            }
        } else {
            for (Player p : Bukkit.getOnlinePlayers()) {
                Point p2;
                Point p1 = new Point(evt.getChunk().getX(), evt.getChunk().getZ());
                if (!(p1.distance(p2 = new Point(p.getLocation().getChunk().getX(), p.getLocation().getChunk().getZ())) < 25.0)) continue;
                this.playersinnewchunks.remove(p.getName());
            }
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        if (event.getReason().equalsIgnoreCase("Kicked for spamming")) {
            if (this.getConfig().getBoolean("PreventSpamKick")) {
                event.setCancelled(true);
            } else if (this.getConfig().getBoolean("MaskKickMessages")) {
                event.setReason(ChatColor.GRAY + "You have lost connection to the server");
            }
        } else if (this.getConfig().getBoolean("MaskKickMessages")) {
            event.setReason(ChatColor.GRAY + "You have lost connection to the server");
        }
    }

    @EventHandler
    private void onBlockDamage(BlockDamageEvent evt) {
        if (this.getConfig().getBoolean("DEBUG")) {
            System.out.println("BlockDamageEvent " + evt.getBlock().getType().toString());
        }
        if (this.getConfig().getBoolean("AllowBreakingBedrock") && evt.getBlock().getType().toString() == "BEDROCK") {
            if (evt.getBlock().getWorld().getName().equalsIgnoreCase("world_nether") && evt.getBlock().getY() > 6 && evt.getBlock().getY() < 123) {
                evt.getBlock().setType(Material.AIR);
            }
            if (evt.getBlock().getWorld().getName().equalsIgnoreCase("world") && evt.getBlock().getY() > 6) {
                evt.getBlock().setType(Material.AIR);
            }
        }
    }

    @EventHandler
    private void onChunkLoadEvent(ChunkLoadEvent evt) {
        int y;
        int z;
        int x;
        int cz;
        int cx;
        Chunk c;
        if (this.getConfig().getBoolean("RemoveALLIllegalBlocksOnCHUNKLOAD")) {
            c = evt.getChunk();
            if (!evt.isNewChunk() && !c.getWorld().getName().equalsIgnoreCase("world_the_end")) {
                cx = c.getX() << 4;
                cz = c.getZ() << 4;
                for (x = cx; x < cx + 16; ++x) {
                    for (z = cz; z < cz + 16; ++z) {
                        for (y = 0; y < 128; ++y) {
                            if (!this.getConfig().getList("BANNED_BLOCKS").contains(c.getBlock(x, y, z).getType().toString()) || y <= 5) continue;
                            if (evt.getChunk().getWorld().getName().equalsIgnoreCase("world_nether") && y < 123) {
                                c.getBlock(x, y, z).setType(Material.AIR);
                            }
                            if (!evt.getChunk().getWorld().getName().equalsIgnoreCase("world")) continue;
                            c.getBlock(x, y, z).setType(Material.AIR);
                        }
                    }
                }
            }
        }
        if (this.getConfig().getBoolean("FillInBedrockFloor")) {
            c = evt.getChunk();
            if (!evt.isNewChunk() && !c.getWorld().getName().equalsIgnoreCase("world_the_end")) {
                cx = c.getX() << 4;
                cz = c.getZ() << 4;
                for (x = cx; x < cx + 16; ++x) {
                    for (z = cz; z < cz + 16; ++z) {
                        for (y = 0; y < 128; ++y) {
                            if (y != 0 || c.getBlock(x, y, z).getType() == Material.BEDROCK) continue;
                            c.getBlock(x, y, z).setType(Material.BEDROCK);
                        }
                    }
                }
            }
        }
        if (this.getConfig().getBoolean("FillInBedrockRoof")) {
            c = evt.getChunk();
            if (!evt.isNewChunk() && c.getWorld().getName().equalsIgnoreCase("world_nether")) {
                cx = c.getX() << 4;
                cz = c.getZ() << 4;
                for (x = cx; x < cx + 16; ++x) {
                    for (z = cz; z < cz + 16; ++z) {
                        for (y = 0; y < 128; ++y) {
                            if (y != 127 || c.getBlock(x, y, z).getType() == Material.BEDROCK) continue;
                            c.getBlock(x, y, z).setType(Material.BEDROCK);
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onRedstoneEvent(BlockRedstoneEvent evt) {
        long now = Instant.now().toEpochMilli();
        double tps_double = Bukkit.getServer().getTPS()[0];
        int tps = (int)tps_double;
        if (tps < this.getConfig().getInt("Redstone")) {
            int current = evt.getOldCurrent();
            evt.setNewCurrent(current);
            if (now - this.lastGathered >= 30000L) {
                this.lastGathered = now;
                System.out.println("Disabled all redstone because tps is " + tps);
            }
        } else {
            int newcurrent = evt.getNewCurrent();
            evt.setNewCurrent(newcurrent);
        }
    }

    @EventHandler
    private void onExplode(EntityExplodeEvent evt) {
        double tps_double = Bukkit.getServer().getTPS()[0];
        int tps = (int)tps_double;
        if (tps < this.getConfig().getInt("Explosions")) {
            evt.setCancelled(true);
        }
        if (this.getConfig().getBoolean("DisableExplosions")) {
            evt.setCancelled(true);
        }
    }

    @EventHandler
    private void onExplodePrime(ExplosionPrimeEvent evt) {
        if (this.getConfig().getBoolean("DisableExplosions")) {
            evt.setCancelled(true);
        }
    }

    @EventHandler
    private void onMove(PlayerMoveEvent evt) {
        if (this.getConfig().getBoolean("DisableAllElytras")) {
            Player player = evt.getPlayer();
            PlayerInventory i = player.getInventory();
            Location l = i.getLocation();
            if (i.getChestplate() != null && i.getChestplate().getType().equals((Object)Material.ELYTRA)) {
                ItemStack elytra = i.getChestplate();
                i.setChestplate(null);
                l.getWorld().dropItemNaturally(l, elytra);
                evt.getPlayer().sendMessage("Elytras disabled due to LAG exploit.");
            }
        }
        double tps_double = Bukkit.getServer().getTPS()[0];
        int tps = (int)tps_double;
        if (evt.getPlayer().isGliding() && tps < this.getConfig().getInt("Elytra")) {
            Player player = evt.getPlayer();
            PlayerInventory i = player.getInventory();
            Location l = i.getLocation();
            evt.setCancelled(true);
            if (this.getConfig().getBoolean("RemoveElytra")) {
                evt.getPlayer().setGliding(false);
                if (i.getChestplate() != null && i.getChestplate().getType().equals((Object)Material.ELYTRA)) {
                    ItemStack elytra = i.getChestplate();
                    i.setChestplate(null);
                    l.getWorld().dropItemNaturally(l, elytra);
                }
            }
        }
        if ((this.getConfig().getBoolean("PreventGoingBelowBedrockFloorOnElytra") || this.getConfig().getBoolean("PreventGoingBelowBedrockFloor")) && evt.getPlayer().getLocation().getY() < 0.0 && !evt.getPlayer().getWorld().getName().equalsIgnoreCase("world_the_end")) {
            evt.getPlayer().getWorld().getBlockAt(evt.getPlayer().getLocation().getBlockX(), 0, evt.getPlayer().getLocation().getBlockZ()).setType(Material.BEDROCK);
            evt.setTo(evt.getFrom().add(0.0, 2.0, 0.0));
        }
    }

    @EventHandler
    private void onInventoryInteractEvent(InventoryInteractEvent evt) {
        if (this.getConfig().getBoolean("DEBUG")) {
            System.out.println("InventoryInteractEvent ");
        }
        if (this.getConfig().getBoolean("RemoveIllegalBlocksOnInteract")) {
            ItemStack[] item = evt.getInventory().getContents();
            this.getConfig().getList("BANNED_BLOCKS").forEach(b -> {
                if (evt.getInventory().contains(Material.getMaterial((String)((String)b)))) {
                    evt.getInventory().remove(Material.getMaterial((String)((String)b)));
                    evt.setCancelled(true);
                }
            });
        }
    }

    @EventHandler
    private void onInventoryClick(InventoryClickEvent evt) {
        if (this.getConfig().getBoolean("RemoveIllegalBlocksOnClick") && evt.getCurrentItem() != null) {
            String item = evt.getCurrentItem().getType().toString();
            if (this.getConfig().getList("BANNED_BLOCKS").contains(item)) {
                if (this.getConfig().getBoolean("DEBUG")) {
                    System.out.println("InventoryClickEvent " + item);
                }
                evt.getCurrentItem().setType(Material.getMaterial((String)this.getConfig().getString("Replacement_Item")));
                evt.setCancelled(true);
            }
        }
    }

    @EventHandler
    private void onInventoryPickup(InventoryPickupItemEvent evt) {
        if (this.getConfig().getBoolean("RemoveIllegalBlocksOnPickup")) {
            String item = evt.getItem().getType().toString();
            if (this.getConfig().getBoolean("DEBUG")) {
                System.out.println("InventoryPickupItemEvent " + item);
            }
            if (this.getConfig().getList("BANNED_BLOCKS").contains(item)) {
                evt.setCancelled(true);
            }
        }
    }

    @EventHandler
    private void onInventoryMove(InventoryMoveItemEvent evt) {
        if (this.getConfig().getBoolean("RemoveIllegalBlocksOnMove")) {
            String item = evt.getItem().getType().toString();
            if (this.getConfig().getList("BANNED_BLOCKS").contains(item)) {
                if (this.getConfig().getBoolean("DEBUG")) {
                    System.out.println("InventoryMoveItemEvent " + item);
                }
                evt.getItem().setType(Material.getMaterial((String)this.getConfig().getString("Replacement_Item")));
                evt.setCancelled(true);
            }
        }
    }

    @EventHandler
    private void onBlockPlace(BlockPlaceEvent evt) {
        if (this.getConfig().getBoolean("DEBUG")) {
            System.out.println("BLOCKPLACED " + evt.getBlockPlaced());
            System.out.println("BLOCK " + evt.getBlock());
            System.out.println("BLOCKAGAINST " + evt.getBlockAgainst());
            System.out.println("BlockReplacedState " + evt.getBlockReplacedState());
            System.out.println("Hand " + evt.getHand());
            System.out.println("ItemInHand " + evt.getItemInHand());
        }
        if (this.getConfig().getBoolean("1b1tPlaceBedrock") && evt.getBlockPlaced().getType().toString().equalsIgnoreCase("BEDROCK")) {
            if (evt.getPlayer().getWorld().getName().equalsIgnoreCase("world_the_end")) {
                evt.setCancelled(true);
            }
            if (evt.getPlayer().getWorld().getName().equalsIgnoreCase("world") && evt.getBlockPlaced().getY() < 10) {
                evt.setCancelled(true);
            }
            if (evt.getPlayer().getWorld().getName().equalsIgnoreCase("world_nether") && (evt.getBlockPlaced().getY() < 10 || evt.getBlockPlaced().getY() > 122)) {
                evt.setCancelled(true);
            }
        }
        if (this.getConfig().getBoolean("PreventPlacingIllegalBlocks")) {
            String block = evt.getBlockPlaced().getType().toString();
            if (this.getConfig().getList("BANNED_BLOCKS").contains(block)) {
                if (this.getConfig().getBoolean("RemoveIllegalBlockOnPlace")) {
                    this.getConfig().getList("BANNED_BLOCKS").forEach(b -> {
                        if (evt.getPlayer().getInventory().contains(Material.getMaterial((String)((String)b)))) {
                            evt.getPlayer().getInventory().remove(Material.getMaterial((String)((String)b)));
                            evt.setCancelled(true);
                        }
                    });
                }
                evt.setCancelled(true);
            }
        }
    }

    @EventHandler
    private void onEntityTeleportEvent(EntityTeleportEvent evt) {
        if (this.getConfig().getBoolean("PreventEndGatewayCrashExploit") && evt.getEntity().getWorld().getName().equals("world_the_end") && !evt.getEntity().isEmpty()) {
            evt.setCancelled(true);
            if (!this.getConfig().getBoolean("NoConsoleOutput")) {
                System.out.println("Prevented a entity (" + evt.getEntity().getName() + ") from going through end gateway at " + evt.getEntity().getLocation());
            }
        }
    }

    @EventHandler
    private void onEntityInteract(final PlayerInteractAtEntityEvent evt) {
        if (this.getConfig().getBoolean("DisableChestsOnDonkeys") && evt.getRightClicked() instanceof ChestedHorse) {
            evt.setCancelled(true);
            new BukkitRunnable(){

                public void run() {
                    if (evt.getPlayer().getInventory().getItemInMainHand().getType() == Material.CHEST) {
                        ((ChestedHorse)evt.getRightClicked()).setCarryingChest(false);
                    }
                    ((ChestedHorse)evt.getRightClicked()).setCarryingChest(false);
                }
            }.runTaskLater((Plugin)this, 2L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCommandPreprocess(PlayerCommandPreprocessEvent evt) {
        Point p2;
        Point p1;
        String msg = evt.getMessage().toLowerCase();
        if (evt.getMessage().equalsIgnoreCase("/ignore") && this.getConfig().getBoolean("FixChatcoIgnoreBug")) {
            evt.getPlayer().sendMessage("\u00a7cYou didn't add a player name....");
            evt.setCancelled(true);
        }
        if (evt.getMessage().equalsIgnoreCase("/tps") && this.getConfig().getBoolean("UseSparkhealth")) {
            evt.getPlayer().performCommand("spark health");
            evt.setCancelled(true);
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)this, () -> evt.getPlayer().sendMessage(ChatColor.GRAY + "This is not the world size, for world size type /stats"), 10L);
        }
        if (evt.getMessage().toLowerCase().startsWith("/nick") && this.getConfig().getBoolean("nickresetonly") && !evt.getMessage().equalsIgnoreCase("/nick off")) {
            evt.getPlayer().sendMessage("\u00a73You can't change your nick but you may reset it by typing /nick off if you have a legacy nick!");
            evt.setCancelled(true);
        }
        if ((evt.getMessage().toLowerCase().startsWith("/tpa ") || evt.getMessage().equalsIgnoreCase("/tpa") || evt.getMessage().toLowerCase().startsWith("/tpahere") || evt.getMessage().toLowerCase().startsWith("/call") || evt.getMessage().toLowerCase().startsWith("/ecall") || evt.getMessage().toLowerCase().startsWith("/etpa") || evt.getMessage().toLowerCase().startsWith("/tpask") || evt.getMessage().toLowerCase().startsWith("/etpask")) && this.getConfig().getBoolean("5000blocksawaytoteleport") && !evt.getPlayer().getWorld().getName().equalsIgnoreCase("world_the_end") && (p1 = new Point(evt.getPlayer().getLocation().getBlockX(), evt.getPlayer().getLocation().getBlockZ())).distance(p2 = new Point(0, 0)) < 5000.0) {
            evt.getPlayer().sendMessage("\u00a73You need to be 5000 blocks away from spawn to teleport!");
            evt.setCancelled(true);
        }
        if (this.getConfig().getBoolean("AllowOPStobypass")) {
            if (!this.getConfig().getList("CommandsWhitelisted").contains(msg.split(" ")[0]) && this.getConfig().getBoolean("CommandWhitelist") && !evt.getPlayer().isOp()) {
                evt.getPlayer().sendMessage("\u00a74Bad command. Type /help for all commands.");
                evt.setCancelled(true);
            }
        } else if (!this.getConfig().getList("CommandsWhitelisted").contains(msg.split(" ")[0]) && this.getConfig().getBoolean("CommandWhitelist")) {
            evt.getPlayer().sendMessage("\u00a74Bad command. Type /help for all commands.");
            evt.setCancelled(true);
        }
    }

    @EventHandler
    private void onChat(AsyncPlayerChatEvent event) {
        if (this.getConfig().getBoolean("Replace@") && event.getMessage().contains("@")) {
            event.setMessage(event.getMessage().replaceAll("@", ""));
            event.getPlayer().sendMessage("stop trying to ping me faggot");
        }
        if (this.getConfig().getBoolean("Preventlinks")) {
            World playerWorld = event.getPlayer().getWorld();
            if (!playerWorld.getName().equals("world")) {
                return;
            }
            Location location = event.getPlayer().getLocation();
            if (location.distance(playerWorld.getSpawnLocation()) > 1000.0) {
                return;
            }
            String msg = event.getMessage();
            for (String string : msg.split(" ")) {
                if (!string.matches(REGEX_CHECK) && !string.matches(HTTP_REGEX_CHECK)) continue;
                System.out.println("Prevented " + event.getPlayer().getName() + " from sending " + event.getMessage() + " because link");
                event.setCancelled(true);
            }
        }
    }
}

