/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.alonsojoin.utils;

import com.alonsoaliaga.alonsojoin.AlonsoJoin;
import com.alonsoaliaga.alonsojoin.utils.LocalUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ProtocolLibUtils {
    private static AlonsoJoin plugin = AlonsoJoin.getInstance();
    private static int jsonType;

    public static int getProtocolActionBarMethod() {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer chatPacket = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        chatPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)"Plugin made by AlonsoAliaga"));
        try {
            chatPacket.getBytes().write(0, (Object)2);
            LocalUtils.logp("ProtocolLib available for action bars. Method: '(byte)2' Hooking..");
            return 0;
        }
        catch (Throwable e1) {
            try {
                chatPacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
                LocalUtils.logp("ProtocolLib available for action bars. Method: 'GAME_INFO'. Hooking..");
                return 1;
            }
            catch (Throwable e2) {
                LocalUtils.logp("ProtocolLib not available for action bars. Skipping..");
                return -1;
            }
        }
    }

    public static void playExplosion(Location location, int power, Collection<Player> players) {
        ProtocolManager pm = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = pm.createPacket(PacketType.Play.Server.EXPLOSION);
        packet.getModifier().writeDefaults();
        packet.getDoubles().write(0, (Object)location.getX()).write(1, (Object)location.getY()).write(2, (Object)location.getZ());
        packet.getFloat().write(0, (Object)Float.valueOf(power));
        players.forEach(online -> {
            try {
                pm.sendServerPacket(online, packet);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        });
    }

    public static void playExplosion(Location location, int power) {
        ProtocolLibUtils.playExplosion(location, power, location.getWorld().getPlayers());
    }

    public static void playExplosion(Location location) {
        ProtocolLibUtils.playExplosion(location, 4, location.getWorld().getPlayers());
    }

    public static void sendActionBar(int method, Player player, String text) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer chatPacket = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        chatPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)text));
        try {
            if (method == 0) {
                chatPacket.getBytes().write(0, (Object)2);
            } else {
                chatPacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            protocolManager.sendServerPacket(player, chatPacket);
        }
        catch (Exception e) {
            LocalUtils.logd("&c[ProtocolLib] Error sending Action Bar to player '" + player.getName() + "'.");
        }
    }

    public static void sendActionBar(int method, Collection<Player> players, String text) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer chatPacket = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        chatPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)text));
        try {
            if (method == 0) {
                chatPacket.getBytes().write(0, (Object)2);
            } else {
                chatPacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
            }
            for (Player player : players) {
                protocolManager.sendServerPacket(player, chatPacket);
            }
        }
        catch (Throwable e) {
            LocalUtils.logd("&c[ProtocolLib] Error sending Action Bar to players.");
        }
    }

    public static void sendJSON(String json) {
        if (jsonType == -1) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.logp("JsonType is -1!");
            }
            return;
        }
        if (AlonsoJoin.getInstance().debugMode) {
            LocalUtils.loge("Attempting to send JSON to " + Bukkit.getOnlinePlayers().size() + " players!");
        }
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer messagePacket = manager.createPacket(PacketType.Play.Server.CHAT);
        messagePacket.getModifier().writeDefaults();
        messagePacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)json));
        try {
            if (jsonType == 0) {
                messagePacket.getBytes().write(0, (Object)1);
            } else {
                messagePacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.CHAT);
            }
            manager.broadcastServerPacket(messagePacket);
        }
        catch (Throwable e) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.loge("Error sending JSON chat packet! You are reading the stacktrace below because debug mode is enabled!");
                e.printStackTrace();
            }
            LocalUtils.logp("Error sending JSON chat packet.");
        }
    }

    public static void sendJSON(Collection<Player> players, String json) {
        if (jsonType == -1) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.logp("JsonType is -1!");
            }
            return;
        }
        if (AlonsoJoin.getInstance().debugMode) {
            LocalUtils.loge("Attempting to send JSON to " + players.size() + " players!");
        }
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer messagePacket = manager.createPacket(PacketType.Play.Server.CHAT);
        messagePacket.getModifier().writeDefaults();
        messagePacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)json));
        try {
            if (jsonType == 0) {
                messagePacket.getBytes().write(0, (Object)1);
            } else {
                messagePacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.CHAT);
            }
            for (Player player : players) {
                manager.sendServerPacket(player, messagePacket);
            }
        }
        catch (Throwable e) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.loge("Error sending JSON chat packet! You are reading the stacktrace below because debug mode is enabled!");
                e.printStackTrace();
            }
            LocalUtils.logp("Error sending JSON chat packet.");
        }
    }

    public static void sendJSON(Player player, String json) {
        if (jsonType == -1) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.logp("JsonType is -1!");
            }
            return;
        }
        if (AlonsoJoin.getInstance().debugMode) {
            LocalUtils.loge("Attempting to send JSON to " + player.getName() + "!");
        }
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer messagePacket = manager.createPacket(PacketType.Play.Server.CHAT);
        messagePacket.getModifier().writeDefaults();
        messagePacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)json));
        try {
            if (jsonType == 0) {
                messagePacket.getBytes().write(0, (Object)1);
            } else {
                messagePacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.CHAT);
            }
            manager.sendServerPacket(player, messagePacket);
        }
        catch (Throwable e) {
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.loge("Error sending JSON chat packet! You are reading the stacktrace below because debug mode is enabled!");
                e.printStackTrace();
            }
            LocalUtils.logp("Error sending JSON chat packet.");
        }
    }

    public static void sendBook(Player player, ItemStack bookItem) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer bookPacket = manager.createPacket(PacketType.Play.Server.CUSTOM_PAYLOAD);
        int slot = player.getInventory().getHeldItemSlot();
        ItemStack old = player.getInventory().getItem(slot);
        try {
            player.getInventory().setItem(slot, bookItem);
            bookPacket.getModifier().writeDefaults();
            ByteBuf bf = Unpooled.buffer((int)256);
            bf.setByte(0, 0);
            bf.writerIndex(1);
            bookPacket.getModifier().write(1, MinecraftReflection.getPacketDataSerializer((Object)bf));
            bookPacket.getStrings().write(0, (Object)"MC|BOpen");
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, bookPacket);
            player.getInventory().setItem(slot, old);
        }
        catch (Throwable e) {
            player.getInventory().setItem(slot, old);
            if (ProtocolLibUtils.plugin.debugMode) {
                LocalUtils.loge("Error sending book packet! You are reading the stacktrace below because debug mode is enabled!");
                e.printStackTrace();
            }
            LocalUtils.logp("Error sending JSON chat packet.");
        }
    }

    static {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer chatPacket = protocolManager.createPacket(PacketType.Play.Server.CHAT);
        chatPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)"Plugin made by AlonsoAliaga"));
        try {
            chatPacket.getChatTypes().write(0, (Object)EnumWrappers.ChatType.CHAT);
            LocalUtils.logp("ProtocolLib available for JSON. Method: 'CHAT'. Hooking..");
            jsonType = 1;
        }
        catch (Throwable e1) {
            try {
                chatPacket.getBytes().write(0, (Object)1);
                LocalUtils.logp("ProtocolLib available for JSON. Method: '(byte)1' Hooking..");
                jsonType = 0;
            }
            catch (Throwable e2) {
                LocalUtils.logp("ProtocolLib not available for JSON. Skipping..");
                jsonType = -1;
            }
        }
    }
}

